// Version de l'IHM
GIWIK.ihm_version = "1.125.58.6_IT1";

// ENVIRONNEMENT LOCAL (SIMULATION) ———————————————————————————————————————————————————————————————————————————————————
if (GIWIK.simulation_mode)
{
	// Chemins des CGI
	GIWIK.cgifile = "../cgi-bin/cgi_simulator.php";
	GIWIK.cgiuploader = "../cgi-bin/CGIuploader";
	GIWIK.cgidownloader = "../cgi-bin/CGIdownloader";

	// Fréquence d'actualisation de l'IHM (en ms)
	GIWIK.update_timeout = 500;
}
// ENVIRONNEMENT PRODUIT ——————————————————————————————————————————————————————————————————————————————————————————————
else
{
	// Chemins des CGI
	GIWIK.cgifile = "../cgi-bin/CGI";
	GIWIK.cgiuploader = "../cgi-bin/CGIuploader";
	GIWIK.cgidownloader = "../cgi-bin/CGIdownloader";


	// Fréquence d'actualisation de l'IHM (en ms)
	GIWIK.update_timeout = 500;
}
//—————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


GIWIK.ihm_codename = 'ins';			// Nom de code de l'IHM
GIWIK.ihm_division = 'ipd';			// Division en charge du produit


GIWIK.system_type = 18;				// Type du système


// Navigateur sous lequel l'IHM a été qualifiée (surcharge de giwik.js)
GIWIK._qualified_browser = {name:"firefox", version:27};

// Nom du produit (fonction du type de système)
//    codename : nom de code du produit, destiné à être testé à la place de system_type pour plus de clarté
//    name : title HTML, datalogging
//    logo : logo du produit sous le voyant principal
//    logo_2ndline : 2nd ligne optionnelle pour le logo produit
//    maintenance : version de l'IHM
//    Note 1 : pour toutes les propriétés autres que "codename", il est possible d'utiliser une fonction qui retourne une chaîne (utile pour l'utilisation de MSG) ou une chaîne
//    Note 2 : toutes les propriétés autres que "codename" sont transformées en fonctions par GIWIK lors de la phase d'initialisation
//    		 --> ex: un appel à la propriété "name" doit donc inclure des () : GIWIK._systems[0].name()
GIWIK._systems =
{
	0  : {codename: "PHINS",		name:"PHINS",      logo: "PHINS",      logo_2ndline: "",     maintenance:"PHINS"},
	1  : {codename: "PHINS_SUBSEA",	name:"PHINS SUBSEA", logo: "PHINS",      logo_2ndline: "SUBSEA", maintenance:"PHINS SUBSEA"},
	2  : {codename: "ROVINS",		name:"ROVINS",     logo: "ROVINS",     logo_2ndline: "",     maintenance:"ROVINS"},
	3  : {codename: "HYDRINS",		name:"HYDRINS",    logo: "HYDRINS",    logo_2ndline: "",     maintenance:"HYDRINS"},
	4  : {codename: "MARINS",		name:"MARINS",     logo: "MARINS",     logo_2ndline: "",     maintenance:"MARINS"},
	5  : {codename: "AIRINS",		name:"AIRINS",     logo: "AIRINS",     logo_2ndline: "",     maintenance:"AIRINS"},
	6  : {codename: "ATLANS",		name:"ATLANS",     logo: "ATLANS",     logo_2ndline: "",     maintenance:"ATLANS"},
	7  : {codename: "QUADRANS",		name:"QUADRANS",   logo: "QUADRANS",   logo_2ndline: "",     maintenance:"QUADRANS"},
	8  : {codename: "MARINS_EXPORT",name:"MARINS",     logo: "MARINS",     logo_2ndline: "",     maintenance:"MARINS EXPORT"},
	9  : {codename: "LANDINS",		name:"LANDINS",    logo: "LANDINS",    logo_2ndline: "",     maintenance:"LANDINS"},
	10 : {codename: "ADVANS",		name:"ADVANS",     logo: "ADVANS",     logo_2ndline: "",     maintenance:"ADVANS"},
	11 : {codename: "OCTANS",		name:"OCTANS",     logo: "OCTANS",     logo_2ndline: "",     maintenance:"OCTANS"},
	12 : {codename: "OCTANS MKII",  name:"OCTANS",	   logo: "OCTANS",     logo_2ndline: "", 	 maintenance:"OCTANS"},		// = OCTANS V
	13 : {codename: "MARINS_BKB",	name:"MARINS",     logo: "MARINS",     logo_2ndline: "",     maintenance:"MARINS BKB"},
	14 : {codename: "OCTANS_NANO",	name:"OCTANS NANO",logo: "OCTANS",     logo_2ndline: "NANO", maintenance:"OCTANS"},
	15 : {codename: "PHINS_C3",		name:"PHINS_C3",   logo: "PHINS",      logo_2ndline: "COMPACT C3", 	maintenance:"PHINS_C3"},			// = INS 50 OEM
	16 : {codename: "PHINS_C7",		name:"PHINS_C7",   logo: "PHINS",      logo_2ndline: "COMPACT C7",  maintenance:"PHINS_C7"},			// = INS 120 OEM
	17 : {codename: "ADVANS_URSA",	 name:"ADVANS_URSA", logo: "ADVANS",   logo_2ndline: "URSA", maintenance:"ADVANS_URSA"},
	18 : {codename: "ROVINS_NANO",	name:"ROVINS_NANO",logo: "ROVINS",     logo_2ndline: "NANO", maintenance:"ROVINS_NANO"},
	19 : {codename: "OCTANS_3000",	name:"OCTANS_SUBSEA",logo: "OCTANS",     logo_2ndline: "SUBSEA",  maintenance:"OCTANS"},
	20 : {codename: "PHINS_C5",		name:"PHINS_C5",   logo: "PHINS",      logo_2ndline: "COMPACT C5", 	maintenance:"PHINS_C5"},			// = INS 50 OEM	
	21 : {codename: "ADVANS_URSA_MEMS",	name:"ADVANS_URSA",   logo: "ADVANS",      logo_2ndline: "URSA", 	maintenance:"ADVANS_URSA"}		
};

GIWIK._available_languages = ['en','fr'];	// Langues disponibles dans l'IHM

// GIWIK.latlong_precision    = 8;				// Précision de sortie des positions
GIWIK.save_to_prom_needed  = true;			// Une commande "save to prom" doit être envoyée dans la foulée d'un envoi de paramètres
GIWIK.w3c_cgi_syntax       = false;			// Indique que le cgi ne supporte pas le standard W3C pour les url ("=" obligatoire après chaque paramètre)


// Liste des plugins impliqués
GIWIK._plugins =
{
	control              : {use_on : 'all_headings',                                     shared : true },
	expertview           : {use_on : 'control_expertview',                               shared : true },
	input_output         : {use_on : ['installation_inputs', 'installation_outputs'],    shared : true },
	options              : {use_on : 'all_headings',                                     shared : true },
	network              : {use_on : 'all_headings',                                     shared : true },
	datalogging          : {use_on : ['datalogging', 'datalogger'],                      shared : true },
	passwords            : {use_on : 'setup_passwords',                                  shared : true },
	matrix               : {use_on : 'installation_inputs',                              shared : true },
	mechanical           : {use_on : ['installation_mechanical', 'installation_inputs'], shared : true },
	lever_arms           : {use_on : ['installation_mechanical', 'installation_inputs'], shared : true },
	maintenance          : {use_on : 'maintenance',                                      shared : true },
	sensor_control       : {use_on : ['sensor_control', 'installation_inputs'],          shared : true },
	select2				 : {use_on : 'installation_outputs',          					 shared : false },

	mechanical_ipd       : {use_on : 'installation_mechanical',                          shared : false},
	maintenance_ipd      : {use_on : 'maintenance',                                      shared : false},
	compass              : {use_on : ['control','options'],                              shared : false},
	internal_datalogging : {use_on : ['datalogging', 'datalogger'],                      shared : false},
	factory				 : {use_on : 'installation_factory',                             shared : false},
	settings_management  : {use_on : 'setup_settingsmanagement',                         shared : false},
	events_viewer        : {use_on : 'events_viewer',                                    shared : false},
	simulation           : {use_on : 'setup_simulation',                                 shared : false},
	upgrade	 			 : {use_on : 'upgrade',								 			 shared : false}
};


GIWIK.init.app = function ()
{
	System_state._ext_sensors = {};

	// PARAMÉTRAGES DES PLUGINS —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	// Plugin options ---------------------------------------------------------------------------------------------------------------------------------------------------
	// GIWIK._plugins.options._coordinate_modes = [0,1]; 	// Indique les modes de coordonnées disponibles : [0/*latlong*/,1/*UTM*/,2/*latlong polaires*/]
															// Reçu dynamiquement de l'embarqué si ligne commentée via les paramètres CoordinateModesList et CoordinateMode
															// Décommenter pour gestion exclusive par l'IHM dans les cookies
															// Note : la gestion du mode 2 (latlong polaires) requiert le fonctionnement dynamique via l'embarqué

	GIWIK._plugins.options.latlong_notation  = true;
	GIWIK._plugins.options.latlong_precision = 8;

	GIWIK._plugins.options.language          = true;		// Choix de la langue
	GIWIK._plugins.options.display_mode      = true;		// Choix du mode affichage (jour/nuit)
	GIWIK._plugins.options.stddev_pos_norm   = true;		// Choix de la norme des écarts types
	GIWIK._plugins.options.attitude_norm 	 = true;		// Choix des normes HRP

	if( GIWIK.system_type==10 || GIWIK.system_type==17 || GIWIK.system_type==21 )
	{
		GIWIK._plugins.options.units =							// Choix des unités pour les types suivants :
		{
			speed : ['meter_per_second','kilometer_per_hour','miles_per_hour'],		// Angle
			distance : ['meter','kilometer'],								// Distance
			angle : ['degree','mil','milliradian']										// Vitesse
		};
	}
	else{
		GIWIK._plugins.options.units =							// Choix des unités pour les types suivants :
		{
			speed : ['meter_per_second','knot'],		// Angle
			angle : ['degree','mil']					// Vitesse
		};
	}


	// Plugin network ---------------------------------------------------------------------------------------------------------------------------------------------------
	GIWIK._plugins.network.repeater_port = 8110;			// Port repeater
	GIWIK._plugins.network.ppp_server = 					// Gestion PPP server
	{
		standard : true 									// Gestion du standard RS232/422
	};
	GIWIK._plugins.network.gateway    = true;				// Gestion du Gateway input
	GIWIK._plugins.network.dns        = false;				//	"
	GIWIK._plugins.network.alias      = true;				// Gestion des Alias
	GIWIK._plugins.network.ntp 		  = true;				// Gestion de la fonction NTP
	GIWIK._plugins.network.ntp_use_dns  = false;			// NTP: IP only or server name
	GIWIK._plugins.gps_ip             = false;				// Gestion de l'adresse IP du GPS
	GIWIK._plugins.network._ethconf   = 					// Infos sur le paramètre de configuration éthernet (pour datalogger)
	{
		param_name   : 'EthConf',
		elcfox_index : 1,
		ipport_index : 3
	};
	GIWIK._plugins.network.broadcast  = false;				//Gestion du broadcast //Disabled for now: Side effects have been seen!!
	GIWIK._plugins.network.vlan       = false;				//Gestion des VLANs: Only for MARINS for the moment

	// Plugin input_output ---------------------------------------------------------------------------------------------------------------------------------------------------
	GIWIK._plugins.input_output.eth_conflicts =		// Gestion des exceptions custom en terme de
	[
		{
		 // io           : 'input', // input|output 	// (optional) validité de l'exception en entrée ou sortie. (default: valable pour les 2)
		 // ip           : '192.168.1.2', 				// (optional) adresse IP à tester
			port         : 8110,						// (optional) port à tester
			tlayer       : 0, 							// (optional) couche de transport 0:"TCP Server", 1:"TCP Client", 2:"UDP", 3:"UDP Broadcast", 4:"UDP Multicast"
			info: {
				msg : MSG(['box','usermsg_io_ethernet_conflict_repeater_port']), // (optional) message utilisateur à afficher en cas de vérification de l'exception
				io_port: 'Repeater'						// Port IO source du conflit
			}
		}
	];

	// Plugin datalogging ---------------------------------------------------------------------------------------------------------------------------------------------------
	GIWIK._plugins.datalogging._ports       = false;		// Définition des port dispos pour l'enregistrement de données (cf. plus haut)
	GIWIK._plugins.datalogging.internal_log =
	{
		enabled : true,										// Disponibilité de l'enregistrement de données en interne
		flows: ['R','A','B','C','D','E','F','G'],			// Generic input/output Flows
		output_ports: false,								// Output ports that can actually be logged (set to false by default to be mapped to input ports)
		input_ports: false									// Input ports that can actually be logged	(set to false by default to be mapped to output ports)
	};

	// Plugin passwords -------------------------------------------------------------------------------------------------------------------------------------------------
	//  Défintion Option Password et droits par Page
	// - access_rights: "viewer", "user" ou "admin"
	GIWIK._plugins.passwords.access_levels =
	[
		{page : "control",                  access_rights : "user"  },
		{page : "control_expertview",       access_rights : "viewer"},
		{page : "datalogging",              access_rights : "user"  },
		{page : "events_viewer",            access_rights : "user"  },
		{page : "options",                  access_rights : "user"  },
		{page : "setup_navigation",         access_rights : "user"  },
		{page : "setup_navigation",         access_rights : "user"  },
		{page : "setup_position",           access_rights : "user"  },
		{page : "upgrade",       			access_rights : "user"  },
		{page : "installation_initialposition", access_rights : "admin" },
		{page : "installation_inputs",      access_rights : "admin" },
		{page : "installation_mechanical",  access_rights : "admin" },
		{page : "installation_outputs",     access_rights : "admin" },
		{page : "installation_network",     access_rights : "admin" },
		{page : "maintenance",              access_rights : "admin" },
		{page : "setup_calibration",        access_rights : "admin" },
		{page : "setup_settingsmanagement", access_rights : "admin" },
		{page : "setup_simulation", 		access_rights : "admin" },
		{page : "setup_warnings", 			access_rights : "admin" },
		{page : "setup_passwords",          access_rights : "admin" },
		{page : "setup_dynamicpositioning", access_rights : "admin" }
	];

	// Plugin mechanical ------------------------------------------------------------------------------------------------------------------------------------------------
	GIWIK._plugins.mechanical.rough_align            = true;
	GIWIK._plugins.mechanical.fine_align             = {min:-45, max:45, step:0.001, jstep:0.1};
	GIWIK._plugins.mechanical.restart_after_sendconf = true;
	GIWIK._plugins.mechanical.lever_arms3_checkbox  = false;
	GIWIK._plugins.mechanical.turret				= false;
	GIWIK._plugins.mechanical.turret2barrelLVA		= false;
	GIWIK._plugins.mechanical.vehicleLVA			= false;
	GIWIK._plugins.mechanical.axes_definition 		= true;
	GIWIK._plugins.mechanical.heading_align_conv 	= 'positive_clockwise';
	GIWIK._plugins.mechanical.roll_align_conv 		= 'positive_left_up';
	GIWIK._plugins.mechanical.pitch_align_conv 		= 'positive_front_down';
	GIWIK._plugins.mechanical.frame_convention 		= 'front_left_up';

	// GIWIK._plugins.mechanical.lever_arms1 = (GIWIK.system_lva) ? true : false;							|
	// GIWIK._plugins.mechanical.lever_arms2 = (GIWIK.system_lva) ? true : false;							|-> Dépendent du système, voir plus bas
	// GIWIK._plugins.mechanical.lever_arms3 = (GIWIK.heave)      ? true : false; // (paramètres de COG)	|

	// Plugin maintenance -----------------------------------------------------------------------------------------------------------------------------------------------
	if( GIWIK.system_type === 21 ){
		GIWIK._plugins.maintenance.new_archi		 = true;
	}
	else {
		GIWIK._plugins.maintenance.new_archi		 = false;
	}
	
	GIWIK._plugins.maintenance.restart_system        = true;		// Fonction restart
	
	if( GIWIK._plugins.maintenance.new_archi ){
		GIWIK._plugins.maintenance._soft_versions        = ['FirmIMUVers','FirmCINTVers', 'KernelVers'];	// liste des différentes versions à afficher
	}
	else{
		GIWIK._plugins.maintenance._soft_versions        = ['LoaderDSPVers', 'FirmDSPVers', 'LoaderCINTVers', 'FirmCINTVers', 'KernelVers'];	// liste des différentes versions à afficher
	}
	if( GIWIK.system_type === 6 ) {
		GIWIK._plugins.maintenance._soft_versions.push('GPSConfVers');
	}
	GIWIK._plugins.maintenance.soft_update           = false;		// mise à jour firmwares/IHM
	GIWIK._plugins.maintenance.reset_to_factory      = true;		// la fonction rest to factory settings est dispo
	GIWIK._plugins.maintenance.support        		 = true;		// Courriel au support
	GIWIK._plugins.maintenance.statistics            = true;		// gestion des statistiques pour le support
	GIWIK._plugins.maintenance.packname            	 = false;		// nom du pack logiciel	

	// Plugin matrix ----------------------------------------------------------------------------------------------------------------------------------------------------
	GIWIK._plugins.matrix.inputs_exts   = true;						// Activation du mode "entrées" avec association port / capteur externe
	GIWIK._plugins.matrix._object_names =							// Nom des objets "Menu" pour les lignes et les colonnes
	{
		rows : 'Menu_extsensor',									// Menu_matrix_rows par défaut
		cols : 'Menu_port'											// Menu_matrix_cols par défaut
	};
	GIWIK._plugins.matrix.all_protocols_by_default   = true;		// Affiche tous les protocoles quand aucun capteur n'est associé à un port (défaut false)

	// Plugin events_viewer ---------------------------------------------------------------------------------------------------------------------------------------------
	GIWIK._plugins.events_viewer.timeout             = 800;			// Fréquence d'actualisation du journal
	GIWIK._plugins.events_viewer.maxevents           = 100;			// Nombre maximum d'évènements affichés

	// Plugin simulation ------------------------------------------------------------------------------------------------------------------------------------------------
	GIWIK._plugins.simulation.hrp                    = true;
	GIWIK._plugins.simulation.position               = true;
	GIWIK._plugins.simulation.heave_surge_sway       = true;
	GIWIK._plugins.simulation.speed                  = true;
	GIWIK._plugins.simulation.acceleration_rotation  = true;
	GIWIK._plugins.simulation.status                 = true;

	// Plugin sensor_control --------------------------------------------------------------------------------------------------------------------------------------------
	GIWIK._plugins.sensor_control.timeout            = 800;			// Fréquence d'actualisation du popup "sensor control"
	GIWIK._plugins.sensor_control.send_request       = true;		// Activation de l'envoi de commandes

	// Plugin compass ---------------------------------------------------------------------------------------------------------------------------------------------------
	GIWIK._plugins.compass.display_option = false;					// Choix d'affichage ou non de la rosace dans la page options
	//———————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	// Liste des entrées disponibles
	//??? GIWIK._inputs  = ['inputs', 'evm'];

	// Altitudes Min/Max
	switch(GIWIK.system_type)
	{
		// Subsea
		case 1:  // Phins SUBSEA (ex PHINS 6000)
			GIWIK._max_alt = [-6000,4000];	break;
		case 2:  // Rovins
		case 20: // Phins compact c5
			GIWIK._max_alt = [-3000,4000];	break;
		case 14: // OCTANS Nano
		case 18: // Rovins Nano
		case 19: // OCTANS 3k
			GIWIK._max_alt = [-4000,4000];	break;
		case 15: // PHINS_COMPACT_C3
			GIWIK._max_alt = [-10000,4000];	break;

		// Air
		case 5:	 // Airins
		case 10: // Advans
		case 17: // URSA
			GIWIK._max_alt = [-500,15000];	break;
		// Others
		default: GIWIK._max_alt = [-6000,4000]; break;
	}

	// Liste des EVM disponibles
	/*switch (GIWIK.system_type)
	{
		case 6  : GIWIK._events_markers = ['A', 'B', 'C'];	break;
		case 10 : GIWIK._events_markers = ['A', 'B'];		break;
		case 15 : GIWIK._events_markers = ['A', 'B'];		break;
		default : GIWIK._events_markers = ['A', 'B', 'C', 'D'];
	}*/

	//
	//GIWIK._events_markers_pro_dic = {"None            ":0, "Ev Marker Rising":10, "Ev Marker Falling":11 };
	//GIWIK._travel_lock_pro_dic = {"None            ":0, "Travel Lock":14 };


	// Par défaut, même conf appliquée en entrée/sortie série
	GIWIK.same_in_out_serial_conf = 1;

	// Définition des ports disponibles
	switch (GIWIK.system_type)
	{
		// Spéficique ATLANS —————————————————————————————————————
		case 6:
			// Liste des ports d'entrée disponibles (X = interne)
			GIWIK._input_ports  = ['D', 'E', 'X'];

			// Labels des ports d'entrée internes
			GIWIK._input_ports_label = ['A', 'B', 'X'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._input_ports_link = [[0,1,2], [0,1,2], [0]];

			// Index interne des ports d'entrée
			GIWIK._input_ports_index  = [4, 5, 100];

			// Liste des ports de sortie disponibles
			GIWIK._output_ports = ['A', 'B'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._output_ports_link = [[0,1,2,3], [0,1,2,3]];

			// Liste des ports possibles pour datalogging externe (hors repeater)
			if(GIWIK.external_datalogging) GIWIK._plugins.datalogging._ports = {A:'A', B:'B', C:'POSTPROCESSING', D:'GPS_RAW'};

			// Liste des ports de sortie possibles pour datalogging interne : on ajoute les ports définis par défaut en interne
			GIWIK._plugins.datalogging.internal_log.output_ports = ['A','B','C','D'];
			GIWIK._plugins.datalogging.internal_log.input_ports = ['D','E'];
			break;

		// Spéficique QUADRANS ————————————————————————————————————
		case 7:
			// Labels des ports d'entrée disponibles (X = interne)
			GIWIK._input_ports  = ['D', 'E'];

			// Liste des ports d'entrée internes
			GIWIK._input_ports_label  = ['A', 'B'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._input_ports_link = [[0,1,2], [0,1,2]];

			// Index interne des ports d'entrée
			GIWIK._input_ports_index  = [4, 5];

			// Liste des ports de sortie disponibles
			GIWIK._output_ports = ['A', 'B', 'C', 'D', 'E'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._output_ports_link = [[0,1,2,3], [0,1,2,3], [1,2], [1,2], [1,2]];

			// Pas de lien entrée/sortie série
			GIWIK.same_in_out_serial_conf = 0;
			break;


		// Spéficique OCTANS ————————————————————————————————————
		case 11:
			// Labels des ports d'entrée disponibles (X = interne)
			GIWIK._input_ports  = ['D', 'E'];

			// Liste des ports d'entrée internes
			GIWIK._input_ports_label  = ['A', 'B'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._input_ports_link = [[0,1,2], [0,1,2]];

			// Index interne des ports d'entrée
			GIWIK._input_ports_index  = [4, 5];

			// Liste des ports de sortie disponibles
			GIWIK._output_ports = ['A', 'B', 'C'];

			//  Outputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._output_ports_link = [[0,1,2,3], [0,1,2,3], [0,1,2,3]];

			// Pas de lien entrée/sortie série
			GIWIK.same_in_out_serial_conf = 0;
			break;


		// Spéficique ADVANS ——————————————————————————————————————
		case 10:
			// Liste des ports d'entrée disponibles (X = interne)
			GIWIK._input_ports  = ['R', 'A', 'B', 'C', 'D', 'E', 'X'];

			// Liste des ports d'entrée disponibles (X = interne)
			GIWIK._input_ports_label  = ['R', 'A', 'B', 'C', 'D', 'E', 'X'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._input_ports_link = [[0], [0,1,2], [0,1,2], [0,1,2], [0,1,2], [0,1,2], [0]];

			// Index interne des ports d'entrée
			GIWIK._input_ports_index  = [200, 1, 2, 3, 4, 5, 100];

			// Liste des ports de sortie disponibles
			GIWIK._output_ports = ['A', 'B', 'C', 'D', 'E'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._output_ports_link = [[0,1,2,3], [0,1,2,3], [0,1,2,3], [0,1,2,3], [0,1,2,3]];

			// Liste des ports de sortie possibles pour datalogging interne : on ajoute les ports définis par défaut en interne
			GIWIK._plugins.datalogging.internal_log.output_ports = ['A','B'];
			GIWIK._plugins.datalogging.internal_log.input_ports = ['A', 'B', 'C', 'D', 'E'];
			break;

		// Specific OCTANS MKII
		case 12:
			// Labels des ports d'entrée disponibles (X = interne)
			GIWIK._input_ports  = ['D', 'E', 'F', 'G'];

			// Liste des ports d'entrée internes
			GIWIK._input_ports_label  = ['A','B','C','D'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._input_ports_link = [[0,1,2], [0,1,2], [0,2], [0,2]];

			// Index interne des ports d'entrée
			GIWIK._input_ports_index  = [4, 5, 6, 7];

			// Liste des ports de sortie disponibles
			GIWIK._output_ports = ['A', 'B', 'C', 'D', 'E'];

			//  Outputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._output_ports_link = [[0,1,2,3], [0,1,2,3], [0,1,2,3], [0,2], [0,2]];

			// Pas de lien entrée/sortie série
			GIWIK.same_in_out_serial_conf = 0;
			break;

		// Specific OCTANS 3000
		case 19:
			// Labels des ports d'entrée disponibles (X = interne)
			GIWIK._input_ports  = ['A', 'B', 'C', 'D', 'E', 'F', 'G'];

			// Liste des ports d'entrée internes
			GIWIK._input_ports_label  = ['A', 'B', 'C', 'D', 'E', 'F', 'G'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._input_ports_link = [[0,1,2], [0,1,2], [0,1,2], [0,1,2], [0,1,2], [0,2], [0,2]];

			// Index interne des ports d'entrée
			GIWIK._input_ports_index  = [1, 2, 3, 4, 5, 6, 7];

			// Liste des ports de sortie disponibles
			GIWIK._output_ports = ['A', 'B', 'C', 'D', 'E'];

			//  Outputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._output_ports_link = [[0,1,2,3], [0,1,2,3], [0,1,2,3], [0,1,2,3], [0,1,2,3]];

			// Pas de lien entrée/sortie série
			GIWIK.same_in_out_serial_conf = 1;
			break;

		// Spéficique OCTANS_NANO ————————————————————————————————————
		case 14:
			// Labels des ports d'entrée disponibles (X = interne)
			GIWIK._input_ports  = ['A', 'B', 'C', 'D'];

			// Liste des ports d'entrée internes
			GIWIK._input_ports_label  = ['A','B','C','D'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._input_ports_link = [[0,1,2], [0,1,2], [0,2], [0,2]];

			// Index interne des ports d'entrée
			GIWIK._input_ports_index  = [1, 2, 3, 4];

			// Liste des ports de sortie disponibles
			GIWIK._output_ports = ['A', 'B', 'C', 'D', 'E'];

			//  Outputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._output_ports_link = [[0,1,2,3], [0,1,2,3], [0,2], [0,2], [0,2]];

			// Pas de lien entrée/sortie série
			GIWIK.same_in_out_serial_conf = 0;
			break;

		// Spéficique INS 120————————————————————————————————————
		case 16:
			// Labels des ports d'entrée disponibles (X = interne)
			GIWIK._input_ports  = ['D', 'E', 'F', 'G'];

			// Liste des ports d'entrée internes
			GIWIK._input_ports_label  = ['A','B','C','D'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._input_ports_link = [[0,1,2], [0,1,2], [0,2], [0,2]];

			// Index interne des ports d'entrée
			GIWIK._input_ports_index  = [4, 5, 6, 7];

			// Liste des ports de sortie disponibles
			GIWIK._output_ports = ['A', 'B', 'C', 'D', 'E'];

			//  Outputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._output_ports_link = [[0,1,2,3], [0,1,2,3], [0,2], [0,2], [0,2]];

			// Pas de lien entrée/sortie série
			GIWIK.same_in_out_serial_conf = 0;
			break;

		// Case HYDRINS
		case 3:
			// Liste des ports d'entrée disponibles
			GIWIK._input_ports  = ['A', 'B', 'C', 'D', 'E'];

			GIWIK._input_ports_label = ['A', 'B', 'C', 'D', 'E'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._input_ports_link = [[0,1,2], [0,1,2], [0,1,2], [0,1,2], [0,1,2]];

			// Index interne des ports d'entrée
			GIWIK._input_ports_index  = [1, 2, 3, 4, 5];

			// Liste des ports de sortie disponibles
			GIWIK._output_ports = ['A', 'B', 'C', 'D', 'E'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._output_ports_link = [[0,1,2,3], [0,1,2,3], [0,1,2,3], [0,1,2,3], [0,1,2,3]];
			
			break;

		// Case LANDINS
		case 9:
			// Liste des ports d'entrée disponibles
			GIWIK._input_ports  = ['A', 'B', 'C', 'D', 'E', 'X'];

			GIWIK._input_ports_label = ['A', 'B', 'C', 'D', 'E', 'X'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._input_ports_link = [[0,1,2], [0,1,2], [0,1,2], [0,1,2], [0,1,2], [0]];

			// Index interne des ports d'entrée
			GIWIK._input_ports_index  = [1, 2, 3, 4, 5, 100];

			// Liste des ports de sortie disponibles
			GIWIK._output_ports = ['A', 'B', 'C', 'D', 'E'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._output_ports_link = [[0,1,2,3], [0,1,2,3], [0,1,2,3], [0,1,2,3], [0,1,2,3]];
			break;

		// ADVANS URSA ——————————————————————————————————————————————
		case 17:
			// Labels des ports d'entrée disponibles (X = interne)
			GIWIK._input_ports  = ['A', 'B', 'X'];

			// Liste des ports d'entrée internes
			GIWIK._input_ports_label  = ['A', 'B', 'X'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._input_ports_link = [[0,1,2], [0,1,2], [0]];

			// Index interne des ports d'entrée
			GIWIK._input_ports_index  = [1, 2, 100];

			// Liste des ports de sortie disponibles
			GIWIK._output_ports = ['A', 'B', 'C', 'D', 'E'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._output_ports_link = [[0,1,2,3], [0,1,2,3], [1,2], [1,2], [1,2]];

			// Pas de lien entrée/sortie série
			//GIWIK.same_in_out_serial_conf = 0;	 //ssi CINT2
			break;

		// ADVANS URSA MEMS ——————————————————————————————————————————————
		case 21:
			// Labels des ports d'entrée disponibles (X = interne)
			GIWIK._input_ports  = ['R', 'A', 'B', 'C', 'X', 'CAN'];

			// Liste des ports d'entrée internes
			GIWIK._input_ports_label  = ['R', 'A', 'B', 'C', 'X', 'CAN'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._input_ports_link = [[0], [0,1,2], [0,1,2], [0,1,2], [0]];

			// Index interne des ports d'entrée
			GIWIK._input_ports_index  = [200, 1, 2, 3, 100, 300];

			// Liste des ports de sortie disponibles
			GIWIK._output_ports = ['A', 'B', 'C', 'D', 'E'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._output_ports_link = [[0,1,2,3], [0,1,2,3], [1,2], [1,2], [1,2]];

			// Pas de lien entrée/sortie série
			//GIWIK.same_in_out_serial_conf = 0;	 //ssi CINT2
			break;
			
		// Par défaut : 5 sorties et 7 entrées ——————————————————————
		default:
			// Liste des ports d'entrée disponibles
			GIWIK._input_ports  = ['A', 'B', 'C', 'D', 'E', 'F', 'G'];

			GIWIK._input_ports_label = ['A', 'B', 'C', 'D', 'E', 'F', 'G'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._input_ports_link = [[0,1,2], [0,1,2], [0,1,2], [0,1,2], [0,1,2], [0,2], [0,2]];

			// Index interne des ports d'entrée
			GIWIK._input_ports_index  = [1, 2, 3, 4, 5, 6, 7];

			// Liste des ports de sortie disponibles
			GIWIK._output_ports = ['A', 'B', 'C', 'D', 'E'];

			//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
			GIWIK._output_ports_link = [[0,1,2,3], [0,1,2,3], [0,1,2,3], [0,1,2,3], [0,1,2,3]];
			break;
	}

	// Liste des ports de sortie disponibles par défaut (hors repeater)
	if(GIWIK.external_datalogging) 
	{
	if (!GIWIK._plugins.datalogging._ports)
	{
		GIWIK._plugins.datalogging._ports = {};

		for (var i in GIWIK._output_ports)
		{
			GIWIK._plugins.datalogging._ports[GIWIK._output_ports[i]] = GIWIK._output_ports[i];
		}
	}
	}

	if (!GIWIK._plugins.datalogging.internal_log.output_ports)
		GIWIK._plugins.datalogging.internal_log.output_ports = GIWIK._output_ports;

	if (!GIWIK._plugins.datalogging.internal_log.input_ports)
		GIWIK._plugins.datalogging.internal_log.input_ports = GIWIK._input_ports;


	// Définition du type de véhicule pour les illustrations
	GIWIK.vehicule_type = 'boat';



	if( GIWIK.system_type === 14 || GIWIK.system_type === 18 || GIWIK.system_type === 21)
	{
		// Liste des pulses de sortie
		GIWIK._output_pulse_list  = [];

		// Nom des pulses d'entrée
		GIWIK._output_pulse_names = ['None'];
	}
	else if ( GIWIK.system_type === 15)
	{
		// Liste des pulses de sortie
		GIWIK._output_pulse_list  = ['A'];

		// Nom des pulses d'entrée
		GIWIK._output_pulse_names = ['None', 'Pulse A'];
	}
	else
	{
		// Liste des pulses de sortie
		GIWIK._output_pulse_list  = ['A', 'B'];

		// Nom des pulses d'entrée
		GIWIK._output_pulse_names = ['None', 'Pulse A','Pulse B'];
	}
	


	// Pour PHINS 6000/SUBSEA, ROVINS, OCTANS 3000, pas de pulse in D
	if (GIWIK.system_type === 1 || GIWIK.system_type === 2 || GIWIK.system_type === 19 || GIWIK.system_type === 20)
	{
		// Liste des pulses d'entrée
		GIWIK._input_pulse_list  = ['A', 'B', 'C'];
		// Nom des pulses d'entrée
		GIWIK._input_pulse_names = ['None', 'Pulse A', 'Pulse B', 'Pulse C'];
	}
	else if (GIWIK.system_type === 10 || GIWIK.system_type === 15)	//ADVANS, PHINS C3, ROVINS NANO
	{
		// Liste des pulses d'entrée
		GIWIK._input_pulse_list  = ['A', 'B'];
		// Nom des pulses d'entrée
		GIWIK._input_pulse_names = ['None', 'Pulse A', 'Pulse B'];
	}
	else if (GIWIK.system_type === 6 || GIWIK.system_type === 7 ) // ATLANS, QUADRANS
	{
		// Liste des pulses d'entrée
		GIWIK._input_pulse_list  = ['A', 'B', 'C', 'D'];
		// Nom des pulses d'entrée
		GIWIK._input_pulse_names = ['None', 'Event A', 'Event B', 'Event C', 'PPS In'];
	}
	else if (GIWIK.system_type === 14 || GIWIK.system_type === 16) // OCTANS_NANO, INS 120
	{
		// Liste des pulses d'entrée
		GIWIK._input_pulse_list  = ['A'];
		// Nom des pulses d'entrée
		GIWIK._input_pulse_names = ['None', 'Pulse A'];
	}
	else if (GIWIK.system_type === 18)	//ADVANS, PHINS C3, ROVINS NANO
	{
		// Liste des pulses d'entrée
		GIWIK._input_pulse_list  = ['A', 'C'];
		// Nom des pulses d'entrée
		GIWIK._input_pulse_names = ['None', 'Pulse A', 'Pulse C'];
	}
	else if (GIWIK.system_type === 17) // URSA
	{
		// Liste des pulses d'entrée
		GIWIK._input_pulse_list  = ['A','B'];
		// Nom des pulses d'entrée
		GIWIK._input_pulse_names = ['None', 'Pulse A', 'Pulse B'];
	}
	else if (GIWIK.system_type === 21) // URSA MEMS
	{
		// Liste des pulses d'entrée
		GIWIK._input_pulse_list  = ['A','B'];
		// Nom des pulses d'entrée
		GIWIK._input_pulse_names = ['None', 'Pulse A', 'Pulse B'];
	}
	else
	{
		// Liste des pulses d'entrée
		GIWIK._input_pulse_list  = ['A', 'B', 'C', 'D'];
		// Nom des pulses d'entrée
		GIWIK._input_pulse_names = ['None', 'Pulse A', 'Pulse B', 'Pulse C', 'Pulse D'];
	}


	// Définition des spécificités du produit ———————————————————————————————————————————————————————————————————————————————————————————————————————————————
	GIWIK.is_marins           = false;	// MARINS system type
	GIWIK.is_gyro			  = false;	// INS type Gyro (OCTANS MKII)
	GIWIK.is_advans			  = false;	// ADVANS
	GIWIK.is_subsea			  = false;	// SUBSEA (PHINS C3/C5/C7/6000/SUBSEA, ROVINS)
	GIWIK.alti_depth          = true;	// gestion de l'altitude/profondeur
	GIWIK.stddev              = true;	// gestion des écarts types
	GIWIK.startmode           = true;	// gestion du mode de démarrage
	GIWIK.altimode            = true;	// gestion du mode d'altitude
	GIWIK.manualspeed         = false;	// gestion vitesse manuelle
	GIWIK.manualattitude	  = false;	// gestion attitude manuelle
	GIWIK.zuptmode            = true;	// gestion du mode ZUPT
	GIWIK.heave               = true;	// gestion du pilonnement (heave Zelath)
	GIWIK.input_event_markers = false;	// gestion des event markers
	GIWIK.current             = true;	// gestion des infos de courant
	GIWIK.system_lva          = true;	// gestion des bras de levier du système
	GIWIK.sensors_lva		  = true;	// gestion des bras de levier capteurs
	GIWIK.sensors_lva_hidden  = false;	// bras de levier capteurs repliés par défaut;
	GIWIK.secondary_lva		  = true;	// bras de levier secondaires
	GIWIK.utmzonemode         = true;   // gestion de la zone UTM
	GIWIK.dynamicpositionning = false;	// Mode DP
	GIWIK.gnss				  = false;  // gestion du label GNSS au lieu de GPS
	GIWIK.enable_forced_sensor = true;	// Activation des cases always true
	GIWIK.sensors_switches	  = true;	// Switches de ctrl des senseurs
	GIWIK.vertical_speed 	  = true;	// Display vertical speed in expert view
	GIWIK.heart_beat 		  = false;  // Heart Beat mechanism
	GIWIK.alarm               = false;  // Alarm mechanism management
	GIWIK.dvl2calibration	  = false;	// Disable DVL2 calibration for now
	GIWIK.manualposition_update = false;	// Gestion update auto données manuelles
	GIWIK.travelled_dist 	  = false;
	GIWIK.dvltype			  = false;	// DVL type (Phased Array)
	GIWIK.trig_DVL_by_pulse	  = false;	// active la fonction de trig du DVL via un pulse de sortie
	GIWIK.speed_saturation 	  = false;	// active la fonction de configuration de la saturation de vitesse
	GIWIK.dir_product_img	  = "";		// dossier contenant les images d'orientations du système à afficher
	GIWIK.navigationmode      = false;	// gestion du mode de navigation
	GIWIK.input_travel_lock   = false;	// gestion du signal travel lock
	GIWIK.geoid				  = false;	// gestion séparation géoidale
	GIWIK.hrp_output_convention = false;
	GIWIK.setuptime			  = true;	// permet d'appliquer au système un temps grossier manuellement
	GIWIK.ProtoListDataBlock  = false;  // active la fonction de selection des datablock présents dans un protocole de sortie
	GIWIK.external_datalogging= false;	// active le datalogger externe
	GIWIK.gps_vtg			  = false;	// VTG
	GIWIK.output_extrapolation = true;	// Extrapolation
	GIWIK.gps_vtg_switch      = false;	// VTG use swith on Control Page
	GIWIK.is_mems			  = false;	// MEMS System Type
	GIWIK.use_odocal_as_syst_mesa  = false;	// Can use ODO calibration as system misalignments
	GIWIK.enable_restore_position  = true;	// Can use restore position mode start
	GIWIK.enable_restore_attitude  = true;	// Can use restore attitude mode start

	// Liste complète des capteurs externes gérés par l'IHM (l'ordre de déclaration définit leur position les uns par rapport aux autres) :
	//gps, gps2, lbl, dvl, logem, logem2, usbl, ctd, depth, utc, odometer, angles, utc2, dvl2

	switch (GIWIK.system_type)
	{
		// Pour PHINS (3IO, 7IO)
		case 0:
			GIWIK.system_case_type = 'surface';
			GIWIK._ext_sensors = {gps:true, gps2:true, lbl:true, dvl:true, dvl2:true, logem:true, logem2:true, usbl:true, usbl2:true, usbl3:true, ctd:true, depth:true, utc:true, utc2:true};
			GIWIK.dynamicpositionning = true;
			GIWIK.heart_beat = true;
			GIWIK.alarm      = true;
			GIWIK._plugins.mechanical.lever_arms3_checkbox  = true;
			GIWIK.setuptime			  = false;
			GIWIK.dvltype			  = true;
			GIWIK.gnss 				  = true;  	// gestion du label GNSS au lieu de GPS
			GIWIK.vehicule_type 	  = 'boat';
			// GIWIK.is_subsea	 		  = true;
			break;

		// Pour PHINS SUBSEA (ex PHINS 6000)
		case 1:
			GIWIK.system_case_type = 'subsea';
			GIWIK._ext_sensors = {gps:true, gps2:true, dvl:true, dvl2:true, logem:true, usbl:true, usbl2:true, usbl3:true, lbl:true, depth:true, ctd:true, utc:true, utc2:true};
			GIWIK.dynamicpositionning = true;
			GIWIK._plugins.mechanical.lever_arms3_checkbox  = true;
			GIWIK.dvltype			  = true;
			GIWIK.setuptime			  = false;
			GIWIK.gnss 				  = true;  	// gestion du label GNSS au lieu de GPS
			GIWIK.vehicule_type 	  = 'rov';
			GIWIK.is_subsea	 		  = true;
			GIWIK.input_event_markers 	= true;
			GIWIK.enable_restore_attitude = false;
			GIWIK._plugins.maintenance.packname = true;
			break;

		// Pour ROVINS
		case 2:
			GIWIK.system_case_type = 'subsea';
			GIWIK._ext_sensors = {gps:true, gps2:true, dvl:true, dvl2:true, logem:true, usbl:true, usbl2:true, usbl3:true, lbl:true, depth:true, ctd:true, utc:true, utc2:true};
			GIWIK._plugins.maintenance.license_activation = true; // Indique que l'IHM est doté du système d'activation de license
			GIWIK.dynamicpositionning = true;
			GIWIK._plugins.mechanical.lever_arms3_checkbox  = true;
			GIWIK.dvltype			  = true;
			GIWIK.setuptime			  = false;
			GIWIK.gnss 				  = true;  	// gestion du label GNSS au lieu de GPS
			GIWIK.vehicule_type 	  = 'rov';
			GIWIK.is_subsea	 		  = true;
			GIWIK.input_event_markers 	= true;
			GIWIK.enable_restore_attitude = false;
			GIWIK._plugins.maintenance.packname = true;
			break;

		// Pour HYDRINS
		case 3:
			GIWIK.system_case_type = 'surface';
			GIWIK._ext_sensors = {gps:true, gps2:true, utc:true, utc2:true};
			GIWIK.gnss		  = true;
			GIWIK.heart_beat = true;
			GIWIK.alarm      = true;
			GIWIK.dynamicpositionning = true;
			GIWIK._plugins.mechanical.lever_arms3_checkbox  = true;
			GIWIK._plugins.maintenance.packname  = false;
			GIWIK.ProtoListDataBlock = false;
			GIWIK.setuptime		= false;
			break;

		// Pour MARINS
		case 4:
			GIWIK.is_marins = true;
			GIWIK.system_case_type = 'surface';
			GIWIK._ext_sensors = {gps:true, gps2:true, dvl:true, dvl2:true, logem:true, logem2:true, ctd:true, depth:true, utc:true, utc2:true, dov:true};
			GIWIK.dynamicpositionning = true;
			GIWIK.heart_beat = true;
			GIWIK.alarm      = true;
			GIWIK._plugins.mechanical.lever_arms3_checkbox  = true;
			GIWIK._plugins.network.vlan = true;
			GIWIK.ProtoListDataBlock  = false;
			GIWIK._plugins.maintenance.packname = false;
			break;

		// Pour AIRINS
		case 5:
			GIWIK.system_case_type = 'surface';
			GIWIK._ext_sensors = {gps:true, angles:true, utc:true};
			GIWIK.vehicule_type = 'plane';
			GIWIK.current = false;
			GIWIK.heave = false;
			GIWIK.input_event_markers = true;
			GIWIK.gnss = true;
			GIWIK.setuptime		= false;
			break;

		// Pour ATLANS
		case 6:

			// Configuration depends on dynamic mode
			var dynamic_mode = STORAGE.get('dynamic_mode','boat').toLowerCase();
			if( dynamic_mode == 'land') dynamic_mode='car';  // Should be 'car' but manage 'land' too
			if( dynamic_mode == 'air') dynamic_mode='plane'; // Should be 'plane' but manage 'air' too

			GIWIK.system_case_type = 'surface';
			GIWIK._ext_sensors = {gps:true, utc:true, odometer: (dynamic_mode=='car' ? true : false) };
			GIWIK.vehicule_type = dynamic_mode;
			GIWIK.current = false;
			GIWIK.heave = (STORAGE.get('heave')!='undefined') ? STORAGE.get('heave') : "false";
			GIWIK.altimode = false;
			GIWIK.utmzonemode = false;
			GIWIK.dynamicmode = true;
			GIWIK.zuptmode = false;
			GIWIK.startmode = false;
			GIWIK.input_event_markers = true;
			GIWIK._plugins.maintenance.statistics = false;
			GIWIK._plugins.network.ppp_server.standard = false;
			GIWIK.gps_ip = true;
			GIWIK.gnss = true;
			break;

		// Pour QUADRANS
		case 7:
			GIWIK.is_gyro = true;
			GIWIK.system_case_type = 'surface';
			GIWIK._ext_sensors = {gps:true, logem:true, utc:true};
			GIWIK._backup_sensors = {gps2:true, logem2:true, utc2:true};
			GIWIK.current = false;
			GIWIK.heave = (STORAGE.get('heave')!='undefined') ? STORAGE.get('heave') : "false";
			GIWIK.zuptmode = false;
			GIWIK.startmode = false;
			GIWIK.manualspeed = true;
			GIWIK.stddev = false;
			GIWIK._plugins.options.stddev_pos_norm   = false;
			GIWIK.alti_depth = false;
			GIWIK.system_lva = false;
			GIWIK._plugins.simulation.position = false;
			GIWIK._plugins.simulation.heave_surge_sway = GIWIK.heave;
			GIWIK._plugins.maintenance.statistics = false;
			GIWIK._plugins.network.ppp_server.standard = false;
			GIWIK.enable_forced_sensor = false;
			GIWIK.sensors_switches = false;
			GIWIK.heart_beat = true;
			GIWIK.alarm      = true;
			GIWIK._plugins.mechanical.lever_arms3_checkbox  = true;
			GIWIK._plugins.network.ntp 		  = false;
			GIWIK.setuptime			  = false;
			GIWIK.ProtoListDataBlock  = false;
			break;

		// Pour MARINS_EXPORT
		case 8:
			GIWIK.is_marins = true;
			GIWIK.system_case_type = 'surface';
			GIWIK._ext_sensors = {gps:true, logem:true, utc:true};
			GIWIK.heart_beat = true;
			GIWIK.alarm      = true;
			GIWIK._plugins.mechanical.lever_arms3_checkbox  = true;
			break;

		// Pour LANDINS
		case 9:
			GIWIK.system_case_type = 'surface';
			GIWIK._ext_sensors = {gps:true, utc:true, odometer:true};
			GIWIK.vehicule_type = 'car';
			GIWIK.current = false;
			GIWIK.heave = false;
			GIWIK.input_event_markers = true;
			GIWIK.gnss = true;
			break;

		// Pour ADVANS
		case 10:
			GIWIK.system_case_type = 'surface';
			GIWIK._ext_sensors = {gps:true, utc:true, odometer:true};
			GIWIK.vehicule_type = 'car';
			GIWIK.is_advans	 = true;
			//GIWIK._plugins.mechanical.pitch_align_conv 		= 'positive_front_up';
			GIWIK.current = false;
			GIWIK.altimode = false;
			GIWIK.heave = false;
			GIWIK.input_event_markers = true;
			GIWIK.travelled_dist = true;
			GIWIK._plugins.mechanical.turret = false;
			GIWIK._plugins.mechanical.axes_definition = false;
			//GIWIK.navigationmode 			= true;
			//GIWIK.input_travel_lock 		= true;
			//GIWIK.geoid 					= true;
			GIWIK.secondary_lva		  		= false;	
			GIWIK.hrp_output_convention 	= false;
			GIWIK._plugins.network.ntp 		= false;
			GIWIK.setuptime			  		= false;
			GIWIK.ProtoListDataBlock  		= false;
			GIWIK.output_extrapolation 		= false;
			GIWIK._plugins.options.attitude_norm 	 = false;	

			// Turret activation: Futur use
			GIWIK._plugins.mechanical.turret = false;

			// Options linked to turret presence
			if( GIWIK._plugins.mechanical.turret === true )
			{
				GIWIK._ext_sensors['angles']=true;
				GIWIK._ext_sensors_expertview_col = {gps:2, odometer:3, angles:3};	// Definition des capteurs en position forcée dans expert view: l'ordre est pris en compte et id correspond à id_colonne [1-2-3]
				GIWIK._plugins.mechanical.turret2barrelLVA	= true;
				GIWIK._plugins.mechanical.vehicleLVA		= true;
			}
			if( GIWIK.hrp_output_convention === true )
			{
				// Liste des ports de sortie disponibles
				GIWIK._output_ports.push('R');

				//  Inputs : Type de connexion ([0]:None,[1]: serial only, [2]: ethernet only, [1,2,3]: serial, ethernet ou serial+ethernet)
				GIWIK._output_ports_link.push([0,1,2,3]);
			}
			break;

		// Pour OCTANS
		case 11:
			GIWIK.system_case_type = 'surface';
			GIWIK._ext_sensors = {gps:true, logem:true, utc:true};
			GIWIK.current = false;
			GIWIK.heave = true;
			GIWIK.zuptmode = false;
			GIWIK.startmode = false;
			GIWIK.manualspeed = true;
			GIWIK.stddev = false;
			GIWIK._plugins.options.stddev_pos_norm   = false;
			GIWIK.alti_depth = false;
			GIWIK.system_lva = true;
			GIWIK._plugins.simulation.position = false;
			GIWIK._plugins.simulation.heave_surge_sway = true;
			GIWIK._plugins.maintenance.statistics = true;
			GIWIK._plugins.network.ppp_server.standard = true;
			GIWIK.enable_forced_sensor = false;
			GIWIK.sensors_switches = false;
			GIWIK._plugins.mechanical.lever_arms3_checkbox  = true;
			GIWIK._plugins.network.ntp 		  = false;
			GIWIK.setuptime			  = false;
			GIWIK.ProtoListDataBlock  = false;
			break;

		// Pour OCTANS MKII
		case 12:
			GIWIK.is_gyro = true;
			GIWIK.system_case_type = 'surface';
			GIWIK._ext_sensors = {gps:true, logem:true, utc:true, gps2:true, logem2:true, utc2:true};
			GIWIK._backup_sensors = {gps2:true, logem2:true, utc2:true};
			GIWIK.current = false;
			GIWIK.zuptmode = false;
			GIWIK.utmzonemode = false;
			GIWIK.startmode = false;
			GIWIK.manualspeed = true;
			GIWIK.stddev = false;
			GIWIK._plugins.options.stddev_pos_norm   = false;
			GIWIK.alti_depth = false;
			GIWIK.enable_forced_sensor = false;
			GIWIK.sensors_switches = false;
			GIWIK.sensors_lva = false;
			GIWIK.sensors_lva_hidden = false;
			GIWIK.vertical_speed = false;
			GIWIK.heart_beat = true;
			GIWIK.alarm      = true;
			GIWIK._plugins.mechanical.lever_arms3_checkbox  = true;
			GIWIK._plugins.upgrade.product_activation = true;
			GIWIK._plugins.network.ntp 		  = false;
			GIWIK.setuptime			  = false;
			GIWIK.ProtoListDataBlock  = false;		
			break;

		// Pour MARINS_BKB
		case 13:
			GIWIK.is_marins = true;
			GIWIK.system_case_type = 'surface';
			GIWIK._ext_sensors = {gps:true, gps2:true, logem:true, logem2:true, depth:true, utc:true, utc2:true};
			GIWIK.heart_beat = true;
			GIWIK.alarm      = true;
			break;

		// Pour OCTANS NANO
		case 14:
			GIWIK.is_gyro = true;
			GIWIK.system_case_type = 'subsea';
			GIWIK.vehicule_type = 'rov';
			//GIWIK._ext_sensors = {gps:true, logem:true, utc:true};
			GIWIK._ext_sensors = {gps:true, logem:true, utc:true, gps2:true, logem2:true, utc2:true};
			GIWIK._backup_sensors = {gps2:true, logem2:true, utc2:true};
			GIWIK.current = false;
			GIWIK.heave = (STORAGE.get('heave')!='undefined') ? STORAGE.get('heave') : "false";
			GIWIK.zuptmode = false;
			GIWIK.utmzonemode = false;
			GIWIK.startmode = false;
			GIWIK.manualspeed = true;
			GIWIK.stddev = false;
			GIWIK._plugins.options.stddev_pos_norm   = false;
			GIWIK.alti_depth = false;
			GIWIK.system_lva = false;
			GIWIK.sensors_lva_hidden = true;
			GIWIK._plugins.simulation.position = false;
			GIWIK._plugins.simulation.heave_surge_sway = false;
			GIWIK._plugins.maintenance.statistics = false;
			GIWIK.enable_forced_sensor = false;
			GIWIK.sensors_switches = false;
			GIWIK.vertical_speed = false;
			GIWIK._plugins.network.ntp 		  = false;
			GIWIK.setuptime			  = false;
			GIWIK.ProtoListDataBlock  = false;			
			break;

		// Pour INS 50
		// case 15:
			// GIWIK.system_case_type = 'surface';
			// GIWIK.alti_depth_mode = "depth";
			// GIWIK._ext_sensors = {gps:true, gps2:true, lbl:true, dvl:true, logem:true, usbl:true, usbl2:true, usbl3:true, ctd:true, depth:true, utc:true, utc2:true};
			// GIWIK.dynamicpositionning = false;
			// GIWIK.heave = false;
			// GIWIK._plugins.network.ppp_server.standard = false;
			// break;

		// PHINS_COMPACT_C3 (ex INS 50)
		case 15:
			GIWIK.dir_product_img		= "imu50";
			GIWIK.is_gyro 				= false;
			GIWIK.system_case_type 		= 'ins50_oem';
			GIWIK.vehicule_type 		= 'auv';
			GIWIK.alti_depth_mode 		= "depth";
			GIWIK._ext_sensors 			= {gps:true, gps2:true, dvl:true, dvl2:true, logem:true, usbl:true, usbl2:true, usbl3:true, lbl:true, depth:true, ctd:true, utc:true, utc2:true};
			GIWIK.dynamicpositionning 	= true;
			GIWIK.heave = (STORAGE.get('heave')!='undefined') ? STORAGE.get('heave') : "false";
			GIWIK._plugins.network.ppp_server.standard = false;
			GIWIK.input_event_markers 	= true;
			GIWIK.trig_DVL_by_pulse	  	= false;
			GIWIK.speed_saturation 	  	= false;
			GIWIK.dvltype			  	= true;
			GIWIK.setuptime			  = false;
			GIWIK.gnss 					= true;  	// gestion du label GNSS au lieu de GPS
			GIWIK.is_subsea	 		    = true;
			GIWIK.enable_restore_position = false;
			GIWIK.enable_restore_attitude = false;
			GIWIK._plugins.maintenance.packname = true;
			GIWIK._plugins.mechanical.lever_arms3_checkbox  = true;
			break;

		// Pour PHINS COMPACT C7
		case 16:
			GIWIK.system_case_type 		= 'surface'; //les images pour ce produit n'exitent pas encore.
			GIWIK.is_gyro 				= false;
			GIWIK.alti_depth_mode 		= "depth";
			GIWIK._ext_sensors 			= {gps:true, gps2:true, dvl:true, dvl2:true, logem:true, usbl:true, usbl2:true, usbl3:true, lbl:true, depth:true, ctd:true, utc:true, utc2:true};
			GIWIK._plugins.network.ppp_server.standard = false;
			GIWIK.output_pulses 		= false;
			GIWIK.dynamicpositionning 	= true;
			GIWIK.heave 				= true;
			GIWIK._plugins.mechanical.lever_arms3_checkbox  = true;
			GIWIK.dvltype			  	= true;
			GIWIK.setuptime			  = false;
			GIWIK.gnss 					= true;  	// gestion du label GNSS au lieu de GPS
			GIWIK.vehicule_type 		= 'auv';
			GIWIK.is_subsea	 		    = true;
			GIWIK.enable_restore_position = false;
			GIWIK.enable_restore_attitude = false;
			GIWIK.input_event_markers 	= true;
			GIWIK._plugins.maintenance.packname = true;
			break;

		// Pour ADVANS URSA
		case 17:
			GIWIK.system_case_type = 'surface';
			GIWIK._ext_sensors = {gps:true, utc:true, odometer:true};
			GIWIK.vehicule_type = 'car';
			GIWIK._plugins.mechanical.axes_definition = false;
			GIWIK.is_advans	 = true;
			GIWIK.current = false;
			GIWIK.altimode = false;
			GIWIK.heave = false;
			GIWIK.input_event_markers = true;
			GIWIK.travelled_dist = true;
			GIWIK.navigationmode 			= true;
			GIWIK.input_travel_lock 		= true;
			GIWIK.geoid 					= true;
			GIWIK._plugins.network.ntp 		= false;
			GIWIK.setuptime			  		= false;
			GIWIK.ProtoListDataBlock  		= false;	
			GIWIK.output_extrapolation 		= false;
			GIWIK.secondary_lva		  		= false;
			GIWIK._plugins.options.attitude_norm 	 = false;			
			break;

		// Pour ROVINS NANO
		case 18:
			GIWIK.dir_product_img		= "rovins_nano";
			GIWIK.system_case_type 		= 'subsea';
			GIWIK.vehicule_type 		= 'rov';
			GIWIK.dynamicpositionning 	= true;	// Mode DP
			GIWIK.gnss				  	= true;  // gestion du label GNSS au lieu de GPS
			GIWIK._ext_sensors 			= {gps:true, gps2:true, dvl:true, dvl2:true, logem:true, usbl:true, usbl2:true, usbl3:true, lbl:true, depth:true, ctd:true, utc:true, utc2:true};
			GIWIK.heave = (STORAGE.get('heave')!='undefined') ? STORAGE.get('heave') : "false";
			GIWIK.dvltype			  	= true;
			GIWIK.setuptime			    = false;
			GIWIK.is_subsea	 		    = true;
			GIWIK.enable_restore_attitude = false;
			GIWIK.input_event_markers 	= true;
			GIWIK._plugins.maintenance.packname = true;
			GIWIK._plugins.mechanical.lever_arms3_checkbox  = true;
			break;

		// Pour OCTANS 3000
		case 19:
			GIWIK.is_gyro = true;
			GIWIK.system_case_type = 'subsea';
			GIWIK.vehicule_type = 'rov';
			GIWIK._ext_sensors = {gps:true, logem:true, utc:true, gps2:true, logem2:true, utc2:true};
			GIWIK._backup_sensors = {gps2:true, logem2:true, utc2:true};
			GIWIK.current = false;
			GIWIK.zuptmode = false;
			GIWIK.utmzonemode = false;
			GIWIK.startmode = false;
			GIWIK.manualspeed = true;
			GIWIK.stddev = false;
			GIWIK._plugins.options.stddev_pos_norm   = false;
			GIWIK.alti_depth = false;
			GIWIK.enable_forced_sensor = false;
			GIWIK.sensors_switches = false;
			GIWIK.sensors_lva = false;
			GIWIK.sensors_lva_hidden = false;
			GIWIK.vertical_speed = false;
			GIWIK.heart_beat = true;
			GIWIK.alarm      = true;
			GIWIK._plugins.mechanical.lever_arms3_checkbox  = true;
			GIWIK.heave = true;
			GIWIK._plugins.network.ntp 		  = false;
			GIWIK.setuptime			  = false;
			GIWIK.ProtoListDataBlock  = false;			
			break;
			
		// Pour PHINS COMPACT C5
		case 20:
			GIWIK.system_case_type = 'subsea';
			GIWIK._ext_sensors = {gps:true, gps2:true, dvl:true, dvl2:true, logem:true, usbl:true, usbl2:true, usbl3:true, lbl:true, depth:true, ctd:true, utc:true, utc2:true};
			GIWIK._plugins.maintenance.license_activation = true; // Indique que l'IHM est doté du système d'activation de license
			GIWIK.dynamicpositionning = true;
			GIWIK._plugins.mechanical.lever_arms3_checkbox  = true;
			GIWIK.dvltype			  = true;
			GIWIK.setuptime			  = false;
			GIWIK.gnss 				  = true;  	// gestion du label GNSS au lieu de GPS
			GIWIK.vehicule_type 	  = 'auv';
			GIWIK.is_subsea	 		  = true;
			GIWIK.enable_restore_position = false;
			GIWIK.enable_restore_attitude = false;
			GIWIK.input_event_markers 	= true;
			GIWIK._plugins.maintenance.packname = true;
			break;

		// Pour ADVSN URSA MEMS
		case 21:
			GIWIK.system_case_type = 'ursa_mems';
			GIWIK.dir_product_img	= "ursa_mems";
			GIWIK.is_advans	 = true;
			GIWIK.is_mems	 = true;
			GIWIK._plugins.mechanical.pitch_align_conv  = 'positive_front_up';
			GIWIK._plugins.mechanical.frame_convention 	= 'front_right_down';
			GIWIK._ext_sensors = {gps:true, utc:true, odometer:true};
			GIWIK.vehicule_type = 'jeep';
			GIWIK._plugins.mechanical.turret = false;
			GIWIK._plugins.mechanical.axes_definition = false;
			GIWIK.current = false;
			GIWIK.altimode = false;
			GIWIK.heave = false;
			GIWIK.input_event_markers = true;
			GIWIK.travelled_dist = true;
			GIWIK.gps_vtg = true;
			GIWIK._plugins.network.ppp_server = false;
			GIWIK.ProtoListDataBlock  		= false;
			GIWIK.output_extrapolation 		= false;
			GIWIK.secondary_lva		  		= false;
			GIWIK._plugins.options.attitude_norm 	 = false;
			GIWIK.setuptime			  		= false;
			GIWIK.manualattitude			= true;
			GIWIK.manualspeed				= false;
			GIWIK.gps_vtg_switch     		= false; 
			GIWIK.use_odocal_as_syst_mesa  		= true;	
			break;
	}

	// Plugin mechanical (suite) ----------------------------------------------------------------------------------------------------------------------------------------
	GIWIK._plugins.mechanical.lever_arms1 = (GIWIK.system_lva) ? true : false;
	GIWIK._plugins.mechanical.lever_arms2 = (GIWIK.system_lva && GIWIK.secondary_lva) ? true : false;
	GIWIK._plugins.mechanical.lever_arms3 = (GIWIK.heave)      ? true : false; // (paramètres de COG)

	// Chemin vers le dossier contenant les images d'orientation du système à afficher
	GIWIK.directories.img_mecha = GIWIK.directories.plugins+'/mechanical_'+GIWIK.ihm_division+'/img';	// Chemin relatif du dossier "img" du plugin "mechanical_xxx" (spécifique division)

	if(GIWIK.dir_product_img == "")
		GIWIK.dir_product_img = GIWIK.system_case_type;

	GIWIK.mechanical_case_img_dir = GIWIK.directories.img_mecha+"/"+GIWIK.dir_product_img;

	// Valeurs remontées par le système destinées à être affichées (mode expert = normal + expert) ——————————————————————————————————————————————————————————————————————
	GIWIK._system_data =
	{
		normal:
		{
			latitude:'position',
			longitude:'position',
			polar_latitude:'position',
			polar_longitude:'position',
			utm_zone:'position',
			utm_north:'position',
			utm_east:'position',
			speed_norm:'speed',
			heading:'angle',
			polar_heading:'angle',
			roll:'angle',
			pitch:'angle'
		},
		expert:
		{
			north_speed:'speed',
			east_speed:'speed',
			polar_north_speed:'speed',
			polar_east_speed:'speed',
			systime:'time',
			systimedays:'day',
			utctime:'time'
		}
	};

	if (GIWIK.vertical_speed)
	{
		GIWIK._system_data.expert = array_merge(GIWIK._system_data.expert,
		{
			vert_speed:'speed'
		});
	}

	if (GIWIK._plugins.mechanical.turret)
	{
		GIWIK._system_data.normal = array_merge(GIWIK._system_data.normal,
		{
			vehicle_heading:'angle', vehicle_roll:'angle', vehicle_pitch:'angle',
			vehicle_latitude:'position', vehicle_longitude:'position', vehicle_utm_zone:'position', vehicle_utm_north:'position', vehicle_utm_east:'position'
		});
	}

	if (GIWIK.is_marins)
	{
		GIWIK._system_data.normal = array_merge(GIWIK._system_data.normal,
		{
			ups_zone:"position",
			ups_north:"position",
			ups_east:"position",
			osgb_zone:"position",
			osgb_north:"position",
			osgb_east:"position",
			osgb_altitude:"position",
			mgrs_zone:"position",
			mgrs_north:"position",
			mgrs_east:"position",
			mgrs_altitude:"position",
			georef_zone:"position",
			georef_north:"position",
			georef_east:"position",
			georef_altitude:"position",
			ecef_x:"position",
			ecef_y:"position",
			ecef_z:"position"
		});
	}

	if (GIWIK.stddev)
	{
		GIWIK._system_data.expert = array_merge(GIWIK._system_data.expert,
		{
			heading_stddev:'angle',
			roll_stddev:'angle',
			pitch_stddev:'angle',
			polar_heading_stddev:'angle',
			latitude_stddev:'distance',
			longitude_stddev:'distance',
			polar_latitude_stddev:'distance',
			polar_longitude_stddev:'distance',
			utm_north_stddev:'distance',
			utm_east_stddev:'distance',
			north_speed_stddev:'speed',
			east_speed_stddev:'speed',
			polar_north_speed_stddev:'speed',
			polar_east_speed_stddev:'speed',
			vert_speed_stddev:'speed',
		});

		if (GIWIK._plugins.mechanical.turret)
		{
			GIWIK._system_data.expert = array_merge(GIWIK._system_data.expert,
			{
				vehicle_heading_stddev:'angle', vehicle_roll_stddev:'angle', vehicle_pitch_stddev:'angle',
				vehicle_latitude_stddev:'distance', vehicle_longitude_stddev:'distance', vehicle_utm_north_stddev:'distance', vehicle_utm_east_stddev:'distance'
			});
		}

		if (GIWIK.is_marins)
		{
			GIWIK._system_data.expert = array_merge(GIWIK._system_data.expert,
			{
				ups_north_stddev:"distance",
				ups_east_stddev:"distance",
				osgb_north_stddev:"distance",
				osgb_east_stddev:"distance",
				osgb_altitude_stddev:"height",
				mgrs_north_stddev:"distance",
				mgrs_east_stddev:"distance",
				mgrs_altitude_stddev:"height",
				georef_north_stddev:"distance",
				georef_east_stddev:"distance",
				georef_altitude_stddev:"height",
				ecef_x_stddev:"distance",
				ecef_y_stddev:"distance",
				ecef_z_stddev:"height"
			});
		}
	}

	if (GIWIK.alti_depth)
	{
		// Définition du label de l'axe Z prédéfini
		if( GIWIK.alti_depth_mode=="depth" || GIWIK.alti_depth_mode=="altitude" )
			GIWIK.alti_depth = GIWIK.alti_depth_mode;
		// Définition du label de l'axe Z en fonction du type d'utilisation (subsea/surface)
		else
		{
			if(GIWIK.system_case_type.match(/^subsea/gi) || GIWIK.system_case_type.match(/^rovins_nano/gi))
			{
				GIWIK.alti_depth = 'depth';
			}
			else
			{
				GIWIK.alti_depth = 'altitude';
			}
		}

		GIWIK._system_data.normal[GIWIK.alti_depth] = 'height';

		if (GIWIK._plugins.mechanical.turret){
			GIWIK._system_data.normal['vehicle_'+GIWIK.alti_depth] = 'height';
		}

		if (GIWIK.stddev)
		{
			GIWIK._system_data.expert[GIWIK.alti_depth+'_stddev'] = 'height';

			if (GIWIK._plugins.mechanical.turret){
				GIWIK._system_data.normal['vehicle_'+GIWIK.alti_depth+'_stddev'] = 'height';
			}
		}
	}
	GIWIK.alti_depth_sign = (GIWIK.alti_depth == 'depth') ? -1 : 1; // doit être défini même si GIWIK.alti_depth === false

	if (GIWIK.current)
	{
		GIWIK._system_data.expert = array_merge(GIWIK._system_data.expert,
		{
			north_current:'speed', east_current:'speed', north_current_stddev:'speed', east_current_stddev:'speed'
		});
	}

	if (GIWIK.heave)
	{
		GIWIK._system_data.normal = array_merge(GIWIK._system_data.normal, {heave: 'height'});
		GIWIK._system_data.expert = array_merge(GIWIK._system_data.expert, {surge: 'height', sway:'height'});
	}

	if( GIWIK.travelled_dist )
	{
		GIWIK._system_data.expert = array_merge(GIWIK._system_data.expert, {travelled_dist: 'distance'});
	}
	//——————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————


	// liste exhaustive de tous les capteurs externes potentiellement dispo (correspond aux indexes du tableau System_state.ExtSToSerial)
	GIWIK._extsensors_fulllist           = ['utc', 'gps', 'gps2', 'depth', 'dvl', 'ctd', 'logem', 'logem2', 'lbl', 'usbl', 'usbl2', 'usbl3', 'odometer', 'angles', 'dov', 'utc2', 'dvl2'];

	// la même chose avec la syntaxe CGI
	GIWIK._extsensors_fulllist_cgisyntax = ['UTC', 'GPS', 'GPS' , 'Depth', 'DVL', 'CTD', 'LogEM', 'LogEM', 'LBL', 'USBL', 'USBL', 'USBL', 'Odometer', 'Angles', 'DOV', 'UTC', 'DVL' ];

	// liste des capteurs activables depuis la page controle (cf. tableau System_state.KFMExtSensor)
	GIWIK._extsensors_kfmfulllist        = ['gps', 'gps2', 'gpsm', 'depth', 'dvlbt', 'dvlwt', 'logem', 'logem2', 'lbl', 'usbl','usbl2','usbl3','odometer','angles','dov','dvl2bt','dvl2wt','gpsvtg','gps2vtg'];


	// Définition des données retournées pour chaque capteur externe déclaré
	if( GIWIK.gps_vtg ){
		GPS_Data = {latitude:'position', longitude:'position', altitude:(GIWIK.alti_depth ? 'height' : false), mode_string:false, stddev:(GIWIK.stddev ? 'distance' : false), vtg_speed:'speed', vtg_course:'angle', time:'time', mode:'gps_mode', delay:(GIWIK.is_gyro ? false :'second')};
	}else{
		GPS_Data = {latitude:'position', longitude:'position', altitude:(GIWIK.alti_depth ? 'height' : false), mode_string:false, stddev:(GIWIK.stddev ? 'distance' : false), time:'time', mode:'gps_mode', delay:(GIWIK.is_gyro ? false :'second')};
	}
	
	GIWIK._ext_sensors['gps']      = GIWIK._ext_sensors['gps']      ? GPS_Data : false;
	GIWIK._ext_sensors['gps2']     = GIWIK._ext_sensors['gps2']     ? GPS_Data : false;
	GIWIK._ext_sensors['logem']    = GIWIK._ext_sensors['logem']    ? {speed:'speed', time:'time'} : false;
	GIWIK._ext_sensors['logem2']   = GIWIK._ext_sensors['logem2']   ? {speed:'speed', time:'time'} : false;
	GIWIK._ext_sensors['lbl']      = GIWIK._ext_sensors['lbl']      ? {nobeacon:'other', latitude:'position', longitude:'position', depth:'height', range:'distance', time:'time'} : false;
	GIWIK._ext_sensors['dvl']      = GIWIK._ext_sensors['dvl']      ?	{	bottom_speedx:'speed', 
																			bottom_speedy:'speed', 
																			bottom_speedz:'speed', 
																			water_speedx:'speed', 
																			water_speedy:'speed', 
																			water_speedz:'speed', 
																			range_tobottom:'height', 
																			sound_speed:'meter_per_second', 
																			time:'time',
																			dvl_delay:'second',
																		} : false;
	GIWIK._ext_sensors['dvl2']     = GIWIK._ext_sensors['dvl2']     ? {bottom_speedx:'speed', bottom_speedy:'speed', bottom_speedz:'speed', water_speedx:'speed', water_speedy:'speed', water_speedz:'speed', range_tobottom:'height', sound_speed:'meter_per_second', time:'time'} : false;
	GIWIK._ext_sensors['usbl']     = GIWIK._ext_sensors['usbl']     ? {nobeacon:'other', tpcode:'other', latitude:'position', longitude:'position', depth:'height', delay:'second', time:'time'} : false;
	GIWIK._ext_sensors['usbl2']    = GIWIK._ext_sensors['usbl2']    ? {nobeacon:'other', tpcode:'other', latitude:'position', longitude:'position', depth:'height', delay:'second', time:'time'} : false;
	GIWIK._ext_sensors['usbl3']    = GIWIK._ext_sensors['usbl3']    ? {nobeacon:'other', tpcode:'other', latitude:'position', longitude:'position', depth:'height', delay:'second', time:'time'} : false;
	GIWIK._ext_sensors['ctd']      = GIWIK._ext_sensors['ctd']      ? {speed:'speed'} : false;
	GIWIK._ext_sensors['depth']    = GIWIK._ext_sensors['depth']    ? {depth:'height', time:'time'} : false;
	GIWIK._ext_sensors['utc']      = GIWIK._ext_sensors['utc']      ? {utc_time:'time'} : false;
	GIWIK._ext_sensors['odometer'] = GIWIK._ext_sensors['odometer'] ? {raw_speed:'pulses_s', speed:'speed', time:'time'} : false;
	GIWIK._ext_sensors['dov'] 	   = GIWIK._ext_sensors['dov'] 		? {dov_chi:'second_arc', dov_eta:'second_arc', dov_norm:'milligal', time:'time'} : false;
	GIWIK._ext_sensors['utc2']     = GIWIK._ext_sensors['utc2']     ? {utc_time:'time'} : false; // idem utc car l'embarqué renvoie uniquement System_state._ext_sensors['utc']
	GIWIK._ext_sensors['angles']   = GIWIK._ext_sensors['angles']   ? {angles_heading:'angle', angles_roll:'angle', angles_pitch:'angle', time:'time'} : false;

	// Détermination de la présence d'au moins capteur de vitesse
	var _speed_sensors = ['dvl','logem','logem2','odometer','dvl2'];
	for (var i in _speed_sensors)
	{
		if (GIWIK._ext_sensors[_speed_sensors[i]])
		{
			GIWIK.speed_sensor = true;
		}
	}

	// Déclaration du tableau des "capteurs" (popup statuts)
	GIWIK._ds_sensors = ['input_output','system','externalsensors'];
	//-------------------------------------------------

	GIWIK.no_navbar = false;	// Permet de masquer le bandeau "entête" de l'IHM


	// Définition des rubriques —————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————————

	// LBO création d'un cookie de status sur l'utilisation du fctory mode
	if(!STORAGE.get('factory_mode_in_use'))  {STORAGE.setSession('factory_mode_in_use',false);}
	// LBO ajout du if et du else
	if(STORAGE.get('factory_mode_in_use') != true)
	{
		// Menu principal  ['titre-rubrique', 'nom physique du dossier']
		GIWIK._headings.push([MSG(['headings','control']), 'control']);
			GIWIK._subheadings[0] = [];

		GIWIK._headings.push([MSG(['headings','installation']), 'installation']);
			GIWIK._subheadings[1] = [];
			GIWIK._subheadings[1].push([MSG(['headings','installation_mechanical']),  'installation_mechanical']);
			GIWIK._subheadings[1].push([MSG(['headings','installation_inputs']),      'installation_inputs']);
			GIWIK._subheadings[1].push([MSG(['headings','installation_outputs']),     'installation_outputs']);
			GIWIK._subheadings[1].push([MSG(['headings','installation_network']),     'installation_network']);
			if (GIWIK.is_marins) {GIWIK._subheadings[1].push([MSG(['headings','installation_initialposition']), 'installation_initialposition']);}
			GIWIK._subheadings[1].push([MSG(['headings','installation_go_to_setup']), 'setup']);

		GIWIK._headings.push([MSG(['headings','setup']), 'setup']);
			GIWIK._subheadings[2] = [];
			GIWIK._subheadings[2].push([MSG(['headings',((GIWIK.manualspeed || GIWIK.manualattitude) ? 'setup_manual' : 'setup_position')+'fix']), 'setup_position']);
			if (GIWIK.startmode || GIWIK.navigationmode || GIWIK.alti_depth || GIWIK.zuptmode || GIWIK.current || GIWIK.utmzonemode) {GIWIK._subheadings[2].push([MSG(['headings','setup_navigation']), 'setup_navigation']);}
			GIWIK._subheadings[2].push([MSG(['headings','setup_warnings']), 'setup_warnings']);
			if (GIWIK._ext_sensors['dvl'] || GIWIK._ext_sensors['dvl2'])      {GIWIK._subheadings[2].push([MSG(['headings','setup_calibration']), 'setup_calibration']);}
			if (GIWIK._ext_sensors['odometer']) {GIWIK._subheadings[2].push([MSG(['headings','setup_calibration_odo']), 'setup_calibration']);}
			GIWIK._subheadings[2].push([MSG(['headings','setup_saverestoresettings']), 'setup_settingsmanagement']);
			GIWIK._subheadings[2].push([MSG(['headings','setup_simulationmode']), 'setup_simulation']);
			if (GIWIK._plugins.passwords)       {GIWIK._subheadings[2].push([MSG(['headings','setup_passwords']), 'setup_passwords']);}
			if (GIWIK.dynamicpositionning) {GIWIK._subheadings[2].push([MSG(['headings','setup_dynamicpositioning']), 'setup_dynamicpositioning']);}
			if (GIWIK.setuptime) {GIWIK._subheadings[2].push([MSG(['headings','setup_time']), 'setup_time']);}

		// Menu secondaire  ['titre-rubrique', 'nom physique du dossier', lien href (!!! échapper les "'" !!!)]
		GIWIK._secondary_headings.push([MSG(['headings','expertview']), 'expertview', GIWIK.window.constructOpenString('../control_expertview/', 990, 732, 10, 10, 'toolbar=0, menubar=0, status=0, resizable=1, scrollbars=1')]);
		if (GIWIK._plugins.events_viewer) {GIWIK._secondary_headings.push([MSG(['headings','eventsviewer']), 'eventsviewer', GIWIK.window.constructOpenString('../events_viewer/', 520, 415, 10, 10, 'toolbar=0, menubar=0, status=0, resizable=1, scrollbars=1')]);}
		GIWIK._secondary_headings.push([MSG(['headings','maintenance']), 'maintenance', '../maintenance/']);
		GIWIK._secondary_headings.push([MSG(['headings','options']), 'options', '../options/']);
	} //LBO

	//Suppression de la page datalogging for MARINS M-Series en mode non-usine
	if(!STORAGE.get('mode_usine'))  {STORAGE.setSession('mode_usine',false);}
	if( ((STORAGE.get('mode_usine')==true) && (GIWIK.system_codename.match("MARINS"))) 
	 || (!GIWIK.system_codename.match("MARINS")))
	{
		GIWIK._headings.push([MSG(['headings','datalogging']), 'datalogging']);
		GIWIK._subheadings[3] = [];
	}

	// Méthodes globales -> exécutées sur toutes les pages ——————————————————————————————————————————————————————————————————————————————————————————————————————————————
	HEADING.readConf.global = function ()
	{
		// Mise à jour des bits de status
		GIWIK.statusBitsInfo.updateAll();

		// Dynamic Mode analyse:
		switch (GIWIK.system_type)
		{
			case  6:	// ATLANS
				var stored_dynamic_mode = STORAGE.get('dynamic_mode','boat');							// Stored in cookies
				var configured_dynamic_mode = System_state.ModeDynamicList[System_state.ModeDynamic];	// Configured in system

				// Dynamic mode changed: Store and relaod if necessary!
				if( stored_dynamic_mode != configured_dynamic_mode )
				{
					STORAGE.set('dynamic_mode',configured_dynamic_mode);
					window.location.reload();
				}
				break;

			default: // Others: Do not use Dynamic mode
				break;
		}


		// Detection de la version de carte processeur
		// si version QNX >= 3 -> CINT2 sinon CINT
		for (var c in window[system].KernelVers)
		{
			maj_version = parseInt(window[system].KernelVers[c]);

			if(isNaN(maj_version) != true)
			{
				if(maj_version >= 3)
				{
					GIWIK.CINTBoardType = 2;
				}
				else
				{
					GIWIK.CINTBoardType = 1;
				}
				break;
			}
		}

		//affichage conditionnel des items du menu principal
		for (i=0; i<GIWIK._headings.length; i++){
			if((GIWIK._headings[i][1].match("datalogging") != null) && ((GIWIK.CINTBoardType < 2) || (window[system].internal_logger === false)) )
			{
				continue;
			}
			
			$("#heading" + i).show();
			
			if(i>0)
				$("#heading_sep" + i).show();
		}		
		
		// Gestion de l'alias réseau : remplacement du nom du produit dans le titre HTML de la page si un alias est défini
		if (GIWIK._plugins.network.alias)
		{
			GIWIK.window.setTitle(System_state.Alias);
		}
	};

	HEADING.getConf.global = function ()
	{
		var _params = {};

		// on récupère la configuration des alertes et des capteurs
		// sur toutes les pages pour mettre à jour le chevron si nécessaire
		_params['KFMExtSensor'] = "";
		_params['ModeZUP'] = "";
		_params['ALERTCNF'] = "";

		if (GIWIK._plugins.options.get_coordinate_modes_from_firmware)
		{
			_params['CoordinateModesList'] = "";
			_params['CoordinateMode'] = "";
		}

		// Gestion de l'alias réseau
		if (GIWIK._plugins.network.alias)
		{
			_params['Alias'] = "";
		}

		// Mode Dynamic
		switch (GIWIK.system_type)
		{
			case  6:	// ATLANS
				_params['ModeDynamicList'] = "";
				_params['ModeDynamic'] = "";
				break;

			default: 	// Others: Do not use Dynamic mode
				break;
		}

		// Demande de la version de l'OS à l'embarqué
		_params['KernelVers'] = "";

		// Gestion Tourelle
		if( GIWIK._plugins.mechanical.turret )
		{
			_params['Turret'] = "";
		}


		return _params;
	};

	HEADING.updatePolarDataDisplay = function()
	{
		// Gestion des Modes polaires
		if (in_array(HEADING.name,['control','control_expertview']))
		{
			// SPEED DATA
			if( GIWIK.is_gyro==true )
			{
				// Gyro: Affichage Speed classique: Mode Lat/Long, UTM ET Polaire
				$('[id$="north_speed_info"], [id$="east_speed_info"]').css('display', '');
			}
			else
			{
				// Hors Gyro: Affichage Speed classique: Mode Lat/Long, UTM
				$('[id$="north_speed_info"], [id$="east_speed_info"]').css('display', GIWIK.coordinate_mode !== 2/*Polar*/ ? '' : 'none');
			}

			// 'LATITUDE/LONGITUDE
			if( GIWIK.is_gyro==true )
			{
				// Gyro: Affichage Lat/Long classique: Mode Lat/Long ET Polaire
				$('[id$="latitude_info"], [id$="longitude_info"]').css('display', GIWIK.coordinate_mode === 0/*LatLong*/ || GIWIK.coordinate_mode === 2/*Polar*/? '' : 'none');

				// Cas particulier des GPS qui ne possèdent pas de valeur de position en UTM : on affiche les latitude et longitude quel que soit le mode de coordonnées
				$('#gps_latitude_info, #gps_longitude_info, #gps2_latitude_info, #gps2_longitude_info').css('display', '');
			}
			else
			{
				//[PHSUR-619]: Non masquage des paramètres Lat/Long pour les LBL: Affichage quelque soit le mode
				$('#lbl_latitude_info, #lbl_longitude_info').css('display', '');
			}

			// POLAR DATA
			if( GIWIK.is_gyro==true )
			{
				// Gyro: Pas d'affiche Données polaires hors Heading
				$('[id$="polar_latitude_info"], [id$="polar_longitude_info"]').css('display', 'none');
				$('[id$="polar_north_speed_info"], [id$="polar_east_speed_info"]').css('display', 'none');
			}
			else
			{
				// Hors Gyro: Affichage données polaires suivant le mode
				$('[id$="polar_latitude_info"], [id$="polar_longitude_info"]').css('display', GIWIK.coordinate_mode === 2/*Polar*/ ? '' : 'none');
				$('[id$="polar_north_speed_info"], [id$="polar_east_speed_info"]').css('display', GIWIK.coordinate_mode === 2/*Polar*/ ? '' : 'none');
			}

			// Heading ———————————————————————————————————————————————————————————————————————————————————————————————————————————
			$('[id="heading_info"]').css('display', GIWIK.coordinate_mode !== 2/*Polar*/ ? '' : 'none');
			$('[id="polar_heading_info"]').css('display', GIWIK.coordinate_mode === 2/*Polar*/ ? '' : 'none');
		}
	};


	HEADING.updateVehicleDataDisplay = function()
	{
		// Gestion affichage données véhicule
		if (in_array(HEADING.name,['control','control_expertview']))
		{
			var display = 'None';

			// Si gestion tourelle
			if (GIWIK._plugins.mechanical.turret)
			{
				// Affichage fct° activation tourelle
				display = (System_state.Turret===1 ? '' : 'none');
			}

			$('[id="vehicle_latitude_info"]').css('display', GIWIK.coordinate_mode === 0/*LatLong*/ ? display : 'none');
			$('[id="vehicle_longitude_info"]').css('display', GIWIK.coordinate_mode === 0/*LatLong*/ ? display : 'none');
			$('[id="vehicle_utm_east_info"]').css('display', GIWIK.coordinate_mode === 1/*UTM*/ ? display : 'none');
			$('[id="vehicle_utm_north_info"]').css('display', GIWIK.coordinate_mode === 1/*UTM*/ ? display : 'none');
			$('[id="vehicle_utm_zone_info"]').css('display', GIWIK.coordinate_mode === 1/*UTM*/ ? display : 'none');
		}
	};

	if (in_array(HEADING.name,['installation_factory','factory_settings'])) // LBO
	{
		delete HEADING.getConf.global;
		delete HEADING.readConf.global;
	}

	// GESTION DES EVENEMENTS DE STATUTS ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// Déclaration du tableau liant les évènements aux données concernés (window._event_datagroup['alignment'] = null; signifie que toutes les données sont impactées)
	GIWIK._data_status_event =
	{
		alignment           : null,
		fine_alignment      : null,
		fast_alignment      : null,
		altitude_saturation : [],
		heave_init 			: [],
		invalid_hrp 		: [],
		speed_saturation    : null,
		fast_alignment_failure : null

	};

	//
	GIWIK._data_status_event['altitude_saturation']['normal'] = ['altitude', 'depth'];
	GIWIK._data_status_event['altitude_saturation']['expert'] = ['altitude', 'depth', 'altitude_stddev', 'depth_stddev'];

	GIWIK._data_status_event['altitude_saturation']['normal'] = ['altitude', 'depth'];
	GIWIK._data_status_event['altitude_saturation']['expert'] = ['altitude', 'depth', 'altitude_stddev', 'depth_stddev'];

	GIWIK._data_status_event['heave_init']['normal'] = ['heave'];
	GIWIK._data_status_event['heave_init']['expert'] = [ 'surge', 'sway', 'heave_speed',  'surge_speed', 'sway_speed'];

	GIWIK._data_status_event['invalid_hrp']['normal'] = ['heading','roll', 'pitch'];
	GIWIK._data_status_event['invalid_hrp']['expert'] = [];


	// Lance toutes les mises à jour du tableau des statuts permises par l'IHM (paramètrées dans "warning configuration")
	GIWIK.statusBitsInfo.updateAll = function ()
	{
		if (typeof System_state.ALERTCNF == 'undefined'){return;}

		// ---------- GYRO Mode --------------
		if( GIWIK.is_gyro==true )
		{
			GIWIK.statusBitsInfo.update(25/*31*/ + 32*4, {'status_off':System_state.ALERTCNF[2]});		// UTC
			GIWIK.statusBitsInfo.update(23 + 32*4, {'status_off':System_state.ALERTCNF[3]});			// Latitude
			GIWIK.statusBitsInfo.update(45 + 32*4, {'status_off':System_state.ALERTCNF[3]});			// Longitude
			GIWIK.statusBitsInfo.update(49 + 32*4, {'status_off':System_state.ALERTCNF[4]});			// Vitesse

			if (System_state.ALERTCNF[2] > 1){
				GIWIK.statusBitsInfo.update(25 + 32*4, {'action_on':4, 'action_off':4});
			}
			else{
				GIWIK.statusBitsInfo.update(25 + 32*4, {'action_on':-1, 'action_off':-1});
			}

			if (System_state.ALERTCNF[3] > 1){
				GIWIK.statusBitsInfo.update(23 + 32*4, {'action_on':4, 'action_off':4});
				GIWIK.statusBitsInfo.update(45 + 32*4, {'action_on':4, 'action_off':4});
			}
			else{
				GIWIK.statusBitsInfo.update(23 + 32*4, {'action_on':-1, 'action_off':-1});
				GIWIK.statusBitsInfo.update(45 + 32*4, {'action_on':-1, 'action_off':-1});
			}

			if (System_state.ALERTCNF[4] > 1){
				GIWIK.statusBitsInfo.update(49 + 32*4, {'action_on':4, 'action_off':4});
			}
			else{
				GIWIK.statusBitsInfo.update(49 + 32*4, {'action_on':-1, 'action_off':-1});
			}

		}
		// ---------- INS Mode --------------
		else
		{
			// UTC
			GIWIK.statusBitsInfo.update(9 + 32*5, {'status_off':System_state.ALERTCNF[2]});

			if (System_state.ALERTCNF[2] > 1)
			{
				GIWIK.statusBitsInfo.update(9 + 32*5, {'action_on':4, 'action_off':4});
			}
			else
			{
				GIWIK.statusBitsInfo.update(9 + 32*5, {'action_on':-1, 'action_off':-1});
			}

			// PPS
			//NO !! Only UTC GIWIK.statusBitsInfo.update(11 + 32*5, {'status_off':System_state.ALERTCNF[2]});

			// Position
			// GPS
			if ((System_state.ALERTCNF[3] > 0) &&
			   (System_state.KFMExtSensor[array_search('gps', GIWIK._extsensors_kfmfulllist)] == 2))
			{
				/* Alert if GPS no longer valid */
				GIWIK.statusBitsInfo.update(13 + 32*2, {'status_off':System_state.ALERTCNF[3]});
				GIWIK.statusBitsInfo.update(13 + 32*2, {'action_on':4, 'action_off':4});
			}
			else
			{
				GIWIK.statusBitsInfo.update(13 + 32*2, {'status_off':-1});
				GIWIK.statusBitsInfo.update(13 + 32*2, {'action_on':-1, 'action_off':-1});
			}

			if (GIWIK._ext_sensors.lbl)
			{
				// LBL
				if ((System_state.ALERTCNF[3] > 0) &&
				   (System_state.KFMExtSensor[array_search('lbl', GIWIK._extsensors_kfmfulllist)] == 2))
				{
					/* Alert if LBL no longer valid */
					GIWIK.statusBitsInfo.update(25 + 32*2, {'status_off':System_state.ALERTCNF[3]});
					GIWIK.statusBitsInfo.update(25 + 32*2, {'action_on':4, 'action_off':4});
				}
				else
				{
					GIWIK.statusBitsInfo.update(25 + 32*2, {'status_off':-1});
					GIWIK.statusBitsInfo.update(25 + 32*2, {'action_on':-1, 'action_off':-1});
				}
			}

			if (GIWIK._ext_sensors.usbl)
			{
				// USBL
				if ((System_state.ALERTCNF[3] > 0) &&
				   (System_state.KFMExtSensor[array_search('usbl', GIWIK._extsensors_kfmfulllist)] == 2))
				{
					/* Alert if USBL no longer valid */
					GIWIK.statusBitsInfo.update(17 + 32*2, {'status_off':System_state.ALERTCNF[3]});
					GIWIK.statusBitsInfo.update(17 + 32*2, {'action_on':4, 'action_off':4});
				}
				else
				{
					GIWIK.statusBitsInfo.update(17 + 32*2, {'status_off':-1});
					GIWIK.statusBitsInfo.update(17 + 32*2, {'action_on':-1, 'action_off':-1});
				}
			}

			if (GIWIK._ext_sensors.dvl)
			{
				// Speed sensor
				// DVL BT
				if ((System_state.ALERTCNF[4] > 0) &&
				   (System_state.KFMExtSensor[array_search('dvlbt', GIWIK._extsensors_kfmfulllist)] == 2))
				{
					/* Alert if DVL BT no longer valid */
					GIWIK.statusBitsInfo.update(9 + 32*2, {'status_off':System_state.ALERTCNF[4]});
					GIWIK.statusBitsInfo.update(9 + 32*2, {'action_on':4, 'action_off':4});
				}
				else
				{
					GIWIK.statusBitsInfo.update(9 + 32*2, {'status_off':-1});
					GIWIK.statusBitsInfo.update(9 + 32*2, {'action_on':-1, 'action_off':-1});
				}

				// DVL WT
				if ((System_state.ALERTCNF[4] > 0) &&
				   (System_state.KFMExtSensor[array_search('dvlwt', GIWIK._extsensors_kfmfulllist)] == 2))
				{
					/* Alert if DVL WT no longer valid */
					GIWIK.statusBitsInfo.update(1 + 32*3, {'status_off':System_state.ALERTCNF[4]});
					GIWIK.statusBitsInfo.update(1 + 32*3, {'action_on':4, 'action_off':4});
				}
				else
				{
					GIWIK.statusBitsInfo.update(1 + 32*3, {'status_off':-1});
					GIWIK.statusBitsInfo.update(1 + 32*3, {'action_on':-1, 'action_off':-1});
				}
			}

			// EMLOG
			if ((System_state.ALERTCNF[4] > 0) &&
			   (System_state.KFMExtSensor[array_search('logem', GIWIK._extsensors_kfmfulllist)] == 2))
			{
				/* Alert if EMLOG no longer valid */
				GIWIK.statusBitsInfo.update(25 + 32*3, {'status_off':System_state.ALERTCNF[4]});
				GIWIK.statusBitsInfo.update(25 + 32*3, {'action_on':4, 'action_off':4});
			}
			else
			{
				GIWIK.statusBitsInfo.update(25 + 32*3, {'status_off':-1});
				GIWIK.statusBitsInfo.update(25 + 32*3, {'action_on':-1, 'action_off':-1});
			}
		} // not Gyro
	};

	GIWIK.analyzeActions = function (_actions)
	{
		var warning_action = in_array(2,_actions);
		var alert_action   = in_array(3,_actions);

		window.alignment_action          	= in_array(101, _actions);	// Indique la présence d'une action "alignement"
		window.finealignment_action      	= in_array(103, _actions);	// Indique la présence d'une action "fine alignment"
		window.fastalignment_action      	= in_array(104, _actions);	// Indique la présence d'une action "fastalignment"
		window.IMOalignment_action   	 	= in_array(105, _actions);	// Indique la présence d'une action "IMOalignment"
		window.optimalalignment_action   	= in_array(106, _actions);	// Indique la présence d'une action "optimalalignment"
		window.strategicalignment_action 	= in_array(107, _actions);	// Indique la présence d'une action "strategicalignment"
		window.systemready_action 		 	= in_array(108, _actions);	// Indique la présence d'une action "systemready"
		window.heaveinit_action    		 	= in_array(102, _actions);	// Indique la présence d'une action "heave init"
		window.crtinvalid_action    	 	= in_array(201, _actions);	// Indique la présence d'une action "CRT invalide"
		window.altitudesaturation_action 	= in_array(202, _actions);	// Indique la présence d'une action "Saturation altitudee"
		window.speedsaturation_action    	= in_array(203, _actions);	// Indique la présence d'une action "Saturation vitesse"
		window.fastalignmentfailed_action	= in_array(204, _actions);	// Indique la présence d'une action "Echec Alignement rapide"
		window.waitposition_action          = in_array(205, _actions);	// Indique la présence d'une action "Wait for Position"
		window.systemsaturation_action   	= in_array(206, _actions);	// Indique la présence d'une action "Saturation système"
		window.imuBadModel_action   		= in_array(207, _actions);	// Indique la présence d'une action "IMU incompatible"

		// Affichage des mesures du bloc haut gauche
		// S'il n'y a aucun évènement spécial, toutes les données sont affichées en bleu
		if( !window.alignment_action && 
			!window.finealignment_action && 
			!window.fastalignment_action && 
			!window.speedsaturation_action && 
			!window.fastalignmentfailed_action && 
			!window.crtinvalid_action &&  
			!window.waitposition_action &&
			!window.systemsaturation_action)
		{
			GIWIK.data.setStatus(1, 'alignment');
		}

		// Boucle pour la gestion des actions spéciales
		var bit;
		for (var i in _actions)
		{
			bit = i.substr(3); // n° du bit déclaré dans GIWIK._status_bits_info

			switch (_actions[i])
			{
				// Alignment
				case 101:
					window.Statuschevron.setStatus(1);
					GIWIK.data.setStatus(2, 'alignment');
					break;

				// Heave init
				case 102:
					window.Statuschevron.setStatus(1);
					GIWIK.data.setStatus(2, 'heave_init');
					break;

				// Démarrage Rapide
				case 104:
					window.Statuschevron.setStatus(1);
					GIWIK.data.setStatus(2, 'fast_alignment');
					break;

				// Fine alignment
				case 103:
					window.Statuschevron.setStatus(1);
					GIWIK.data.setStatus(2, 'fine_alignment');
					break;

				// CRT invalides (toujours accompagnée d'une action 2)
				case 201:
					GIWIK.data.setStatus(2, 'invalid_hrp');
					MSG.setGlobalStatus(2001);
					break;

				// Saturation altitude
				case 202:
					window.Statuschevron.setStatus(3);
					GIWIK.data.setStatus(3, 'altitude_saturation');
					MSG.setGlobalStatus(2002);
					break;

				// Saturation vitesse
				case 203:
					window.Statuschevron.setStatus(3);
					GIWIK.data.setStatus(3, 'speed_saturation');
					MSG.setGlobalStatus(2003);
					break;

				// Echec Restauration Attitude
				case 204:
					window.Statuschevron.setStatus(3);
					GIWIK.data.setStatus(3, 'fast_alignment_failure');
					MSG.setGlobalStatus(2004);
					break;

				// Wait for Position
				case 205:
					window.Statuschevron.setStatus(2);
					GIWIK.data.setStatus(2, 'wait_for_position');
					MSG.setGlobalStatus(1502);
					break;
					
				// Saturation système
				case 206:
					window.Statuschevron.setStatus(3);
					GIWIK.data.setStatus(3, 'system_saturation');
					MSG.setGlobalStatus(2005);
					break;

				// IMU incompatible
				case 207:
					window.Statuschevron.setStatus(3);
					GIWIK.data.setStatus(3, 'Incompatible IMU');
					MSG.setGlobalStatus(2502);
					break;

				// ZUPT Mode
				case 312:
					if (HEADING.name == 'control')
					{
						if (in_array(GIWIK.system_type, [6,9,10,17]))
						{
							if (GIWIK._ui_status_unified[112] && GIWIK._ui_status_unified[114])
							{
								//alert('ZUPT_ANC Activé');
								$('#'+GIWIK.statusBitsInfo.msgDomId(112)).css('display','none');
								$('#'+GIWIK.statusBitsInfo.msgDomId(114)).css('display','none');
								$('#'+GIWIK.statusBitsInfo.msgDomId(312)).css({'display':'','color':GIWIK.css['color_'+GIWIK._status_bits_info[312].status_on]});
							}
							else
							{
								$('#'+GIWIK.statusBitsInfo.msgDomId(312)).css('display','none');
							}
							if (GIWIK._ui_status_unified[113] && GIWIK._ui_status_unified[115])
							{
								//alert('ZUPT_ANC Valid');
								$('#'+GIWIK.statusBitsInfo.msgDomId(113)).css('display','none');
								$('#'+GIWIK.statusBitsInfo.msgDomId(115)).css('display','none');
								$('#'+GIWIK.statusBitsInfo.msgDomId(313)).css({'display':'','color':GIWIK.css['color_'+GIWIK._status_bits_info[313].status_on]});
							}
							else
							{
								$('#'+GIWIK.statusBitsInfo.msgDomId(313)).css('display','none');
							}
						}
					}
					break;

				case 401:
					if(STORAGE.get('mode_usine') == false)
					{
						STORAGE.setSession('mode_usine',true);
						window.location.reload();
					}
					break;

				case 402:
					if(STORAGE.get('mode_usine') == true)
					{
						STORAGE.setSession('mode_usine',false);
						window.location.reload();
					}
					break;
			}
		}

		// Affichage des mesures du bloc haut gauche
		if (HEADING.name == 'control' || HEADING.name == 'control_expertview')
		{
			// S'il n'y a aucun évènement spécial, toutes les données sont affichées en bleu
			if (!window.alignment_action && !window.finealignment_action && !window.fastalignment_action && !window.altitudesaturation_action && !window.speedsaturation_action && !window.fastalignmentfailed_action && !window.waitposition_action && ! window.heaveinit_action)
			{
				GIWIK.data.setStatus(1);
			}

		}

		// Manage Heave Feature Enabled/Disabled from Embedded
		if( (typeof System_state.is_heave!='undefined') &&	(System_state.is_heave != STORAGE.get('heave')) )
		{
			// Memoriser is_heave dans le cookie et recharger la page
			STORAGE.setPermanent('heave', System_state.is_heave);
			window.location.reload();
		}

	};
};

// Indique que le chargement du fichier est terminé
GIWIK._files['app.js'].loaded = true;

